/***************************************************************

  BayCom(R)           Packet-Radio fuer IBM PC

  BayCom-Terminal


  -----------------------
  Terminal Video Routines
  -----------------------

  Copyright (C) 1999 Flori Radlherr, DL8MBT, flori@baycom.org
      
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ***************************************************************/


#include "bct.h"

/*---------------------------------------------------------------------------*/

// a lot of ugly globals :(

video far *dossave=NULL;
unsigned doscursor;
video far *vram;
video att=0x7000;
video catt=0x0700;
char colset=0;
char egavga=0;

char maxline=24;
char maxcol=80;

char top[WINDOWS];
char bottom[WINDOWS];
char line[WINDOWS];
char column[WINDOWS];
enum WND wnd;
char remotefl=0;
char prgende=FALSE;
char curwin=txwin;
int bildport=1;
int  replace=0;
long unixtime;
long tastentime;
int bildein=1;
int maxports;
int miniram;
long unsigned freekb=90000L;
int rxback;
int txback;

/*---------------------------------------------------------------------------*/

static unsigned xbufvideo;
static char xbufline;
static char xbufcolumn;

static struct text_info dosbildschirm;
static struct text_info sccbildschirm;
static unsigned doslen;

char *abortmsg="";

char *lstext[]=
  { "Disconnected  ",
    "Link setup    ",
    "Frame reject  ",
    "Disc Request  ",
    "Info Transfer ",
    "Reject sent   ",
    "Wait ACK      "
  };

/*---------------------------------------------------------------------------*/

void set_color(farbe_t farbe,int statline)
{ if(farbe==blackcolor)
    att=catt=0x0700;
  else
  { att=wt->attr[farbe+colset];
    catt=wt->attr[ctlcolor+colset];
    if(statline)
    { if(statline==1)
	if(mauszeile()==wt->txwinlen) att^=0x7700;
      if(statline==2)
	if(mauszeile()==wt->divline) att^=0x7700;
    }
  }
}

/*---------------------------------------------------------------------------*/

//  Bildfenster loeschen
void cls(void)
{ int i;
  video bline[140];
  video blank=att|' ';
  int psave=b->port;

  if(wnd==monwin)
    set_context(0);

  for (i=0;i<maxcol;i++)
    bline[i]=blank;

  if(((b->port==bildport) || (wnd==monwin)) && bildein)
  { video far *dest=vram+(top[wnd]*maxcol);
    for (;dest<(vram+(1+bottom[wnd])*maxcol);dest+=maxcol)
      memmove(dest,bline,maxcol*2);
  }
  if(wnd==monwin || wnd==rxwin)
  { video *dest=b->rxbufptr;
    for (;dest<b->rxbufptr+(rxback*maxcol);dest+=maxcol)
      memmove(dest,bline,maxcol*2);
    b->rxbufbegin=0;
    b->rxbufvideo=30;
    b->rxbufend=31+bottom[wnd]-top[wnd];
    b->rbufcolumn=0;
    b->rbufline=0;
  }
  if(wnd==txwin)
  { video *dest=b->txbufptr;
    for (;dest<b->txbufptr+(txback*maxcol);dest+=maxcol)
      memmove(dest,bline,maxcol*2);
    b->txbufbegin=0;
    b->txbufvideo=0;
    b->txbufend=1+bottom[wnd]-top[wnd];
    b->cbufcolumn=0;
    b->cbufline=0;
  }
  line[wnd]=top[wnd];
  column[wnd]=0;

  set_context(psave);
}

/*---------------------------------------------------------------------------*/

// 
//  Fenster nach oben scrollen
// 
void scroll(int anschlag)
{ int i;
  int len=1+bottom[wnd]-top[wnd];
  video blank=att|' ';
  int bline;
  video *oldline=NULL;
  int port=b->port;

  if(wnd==monwin || wnd==rxwin)
  { oldline=b->rxbufptr+b->rxbufvideo*maxcol;
    bline=(b->rxbufvideo+len)%rxback;
    if(bline==b->rxbufend)
    { if(anschlag) return;
      for(i=0;i<maxcol;i++)
	b->rxbufptr[bline*maxcol+i]=blank;
      b->rxbufend=(bline+1)%rxback;
      if(bline==b->rxbufbegin)
	b->rxbufbegin=(bline+1)%rxback;
    }
    b->rxbufvideo=(++b->rxbufvideo)%rxback;
  }
  else if(wnd==txwin)
  { oldline=b->txbufptr+b->txbufvideo*maxcol;
    bline=(b->txbufvideo+len)%txback;
    if(bline==b->txbufend)
    { if(anschlag && (((*(vram+maxcol*bottom[wnd]))&0xff)==0x20))return;
      for(i=0;i<maxcol;i++)
	b->txbufptr[bline*maxcol+i]=blank;
      b->txbufend=(bline+1)%txback;
      if(bline==b->txbufbegin)
	b->txbufbegin=(bline+1)%txback;
    }
    b->txbufvideo=(++b->txbufvideo)%txback;
  }

  if((port==bildport) && bildein)
  { video far *source=vram+maxcol*(top[wnd]+1);
    video far *dest=vram+maxcol*top[wnd];

    if(oldline) memmove(oldline,dest,2*maxcol);
    memmove(dest,source,(bottom[wnd]-top[wnd])*(2*maxcol));

    if(wnd==monwin || wnd==rxwin)
    { for(i=0;i<maxcol;i++)
       *(vram+(bottom[wnd]*maxcol+i))=b->rxbufptr[(bline*maxcol)+i];
    }
    else if(wnd==txwin)
    { for(i=0;i<maxcol;i++)
       *(vram+(bottom[wnd]*maxcol+i))=b->txbufptr[(bline*maxcol)+i];
    }
    else
    { for(dest=vram+(bottom[wnd]*maxcol);
        dest<vram+((1+bottom[wnd])*maxcol);dest++)
       *dest=blank;
    }
  }
}

/*---------------------------------------------------------------------------*/

// 
//  Fenster nach unten scrollen
// 
int scrolldn(int anschlag)
{ int i;
  int len=1+bottom[wnd]-top[wnd];
  video blank=att|' ';
  int bline;
  video *oldline;
  int port=b->port;

  if(wnd==monwin || wnd==rxwin)
  { oldline=b->rxbufptr+((b->rxbufvideo+len-1)%rxback)*maxcol;
    bline=(b->rxbufvideo+(rxback-1))%rxback;
    if(b->rxbufvideo==b->rxbufbegin)
    { if(anschlag) return 0;
      else
      { for(i=0;i<maxcol;i++)
	  b->rxbufptr[bline*maxcol+i]=blank;
	b->rxbufbegin=(bline+(rxback-1))%rxback;
      }
    }
    b->rxbufvideo=bline;
  }
  else if(wnd==txwin)
  { oldline=b->txbufptr+((b->txbufvideo+len-1)%txback)*maxcol;
    bline=(b->txbufvideo+(txback-1))%txback;
    if(b->txbufvideo==b->txbufbegin)
    { if(anschlag) return 0;
      else
      { for(i=0;i<maxcol;i++)
	  b->txbufptr[bline*maxcol+i]=blank;
	b->txbufbegin=(bline+(txback-1))%txback;
      }
    }
    b->txbufvideo=bline;
  }

  if((port==bildport) && bildein)
  { video far *source=vram+maxcol*top[wnd];
    video far *dest=vram+maxcol*(top[wnd]+1);

    if(anschlag)                    /* beim Fenster ziehen kein linesave!! */
      memmove(oldline,source+((len-1)*maxcol),2*maxcol);
    memmove(dest,source,(bottom[wnd]-top[wnd])*(2*maxcol));

    if(wnd==monwin || wnd==rxwin)
    { for(i=0;i<maxcol;i++)
       *(vram+(top[wnd]*maxcol+i))=b->rxbufptr[(bline*maxcol)+i];
    }
    else if(wnd==txwin)
    { for(i=0;i<maxcol;i++)
       *(vram+(top[wnd]*maxcol+i))=b->txbufptr[(bline*maxcol)+i];
    }
    else
    { for(dest=vram+(top[wnd]*maxcol);dest<vram+((1+top[wnd])*maxcol);dest++)
       *dest=blank;
    }
  }
  return 1;
}

/*---------------------------------------------------------------------------*/

//  Ein Zeichen auf den Bildschirm ausgeben */
void putv(int buchst)
{
  if(setuprun)
  { putvsetup1(buchst);
    return;
  }
  if(remotefl) tnc_put(buchst);
  if(uninit)   return;

  if(buchst==13)
  { { column[wnd]=0;
      if(line[wnd]>=bottom[wnd])
	scroll(0);
      else
	line[wnd]++;
    }
    if(b->port!=bildport && wnd==rxwin)
      b->blinkon=1;
  }
  else
    putvo(buchst);
}

/*---------------------------------------------------------------------------*/

//  Ein Zeichen ohne CRLF auf den Bildschirm ausgeben */
void putvo(int buchst)
{
  if(buchst==9)
  { do
      putvo(' ');
    while(column[wnd]&7);
  }
  else
  { if(!(buchst&0xe0))
      buchst|=(64|catt);
    else
      buchst|=att;

    if((b->port==bildport) && bildein)
      *(vram+(line[wnd]*maxcol)+(column[wnd]++))=buchst;
    else if(wnd==monwin || wnd==rxwin)
      b->rxbufptr[((line[wnd]-top[wnd]+b->rxbufvideo)%rxback)
				     *maxcol+column[wnd]++]=buchst;
    else if(wnd==txwin)
      b->txbufptr[((line[wnd]-top[wnd]+b->txbufvideo)%txback)
                                     *maxcol+column[wnd]++]=buchst;

    if(column[wnd]>(maxcol-1))
      if(wnd==statln || wnd==stat2)
	column[wnd]--;
      else
	putv(13);
  }
}

/*---------------------------------------------------------------------------*/

// 
//   Momentanen Textmodus setzen
// 
void settextinfo(struct text_info *mode)
{ textattr(mode->attribute);
  textmode(mode->currmode);
  gotoxy(mode->curx,mode->cury);
}

/*---------------------------------------------------------------------------*/

// 
//       Hardwarecursor positionieren
// 
void setzcurs(int tx)
{ union REGS rg;
  rg.h.ah = 2;
  rg.h.bh = 0;
  if(tx>0)
  { rg.h.dh = line[curwin];
    rg.h.dl = column[curwin];
  }
  else if(tx<0)
    rg.x.dx=0x4000; /* Cursor verschwinden lassen */
  else
    rg.x.dx=0;
  int86(0x10,&rg,&rg);
}

/*---------------------------------------------------------------------------*/

// 
//       Initialize EGA mode
// 
void egaopen(void)
{ union REGS rg;
  rg.x.ax = 3;
  int86(0x10,&rg,&rg);
  rg.h.ah = 17;                     /* set char. generator function code */
  rg.h.al = 18;                     /* 18 to 8 by 8 double dot ROM */
  rg.h.bl = 0;                      /* block 0 */
  int86(0x10,&rg,&rg);
  rg.h.ah = 18;                     /* alternate select function code */
  rg.h.al = 0;                      /* clear AL for no good reason */
  rg.h.bl = 32;                     /* alt. print screen routine */
  int86(0x10,&rg,&rg);
}

/*---------------------------------------------------------------------------*/

void sccvideo(void)
{ settextinfo(&sccbildschirm);
  if(egavga)
    egaopen();
  _setcursortype(_SOLIDCURSOR);
}

/*---------------------------------------------------------------------------*/

// 
//       De-initialize EGA screen
// 
void dosvideo(void)
{ union REGS rg;
  settextinfo(&dosbildschirm);
  if(dossave && (!wt->dosclear))
    memmove(vram,dossave,doslen);
  else
    clrscr();
  rg.x.ax=0x0100;
  rg.x.cx=doscursor;
  int86(0x10,&rg,&rg);
  if(abortmsg[0])
  { printf("\a>>> Unrecoverable internal error:\n    %s\n",
           abortmsg);
  }
}

/*---------------------------------------------------------------------------*/

void dosabspeichern(int platz)
{ gettextinfo(&dosbildschirm);
  doslen=peekb(0x40,0x4a)*(peekb(0x40,0x84)+1)*2;
  if(!wt->dosclear && platz && !miniram)
  { if(!dossave && platz==1)
      dossave=(unsigned *)farmalloc(doslen);
    if(dossave)
      memmove(dossave,vram,doslen);
  }
  doscursor=peek(0x40,0x60);
  atexit(dosvideo);
}

/*---------------------------------------------------------------------------*/

// 
//       Suche nach Video-Karte, lege video-Parameter fest
// 
void initvideo(void)
{
  union REGS rg;
  unsigned long mem=coreleft();
  long portlines;
  int pnummer;
  int maxp=maxports;

  replace=!wt->insmode;

  doslen=peekb(0x40,0x4a)*(peekb(0x40,0x84)+1)*2;
  gettextinfo(&dosbildschirm);
  if(dosbildschirm.currmode==7)
    vram=(video far *)0xb0000000L;
  else
    vram=(video far *)0xb8000000L;

  maxline=wt->termlines-1;
  maxcol=wt->termcolumn;

  if(wt->colordisp)
    colset=maxcolor;
  else
    colset=0;

  if(vram==(video far *)0xb0000000L)
    colset=0;
  else if(wt->vgalines)
  { rg.x.ax = 0x1200;                       /* test if EGA present */
    rg.x.bx = 0xff10;
    int86(0x10,&rg,&rg);                    /* If EGA, bh=0-1 and bl=0-3 */
    if(!(rg.x.bx & 0xfefc))
    { dosabspeichern(mem>100000L);
#if !WITHNUDL
      egavga=1;
      egaopen();
#endif
      maxline=peekb(0x40,0x84);      /* bioslines */
    }
  }
  if(!dossave) dosabspeichern(mem>100000L);
  _setcursortype(_SOLIDCURSOR);
  putchar(0);                       /* Cursor initialisieren */

  gettextinfo(&sccbildschirm);

  portlines=(long)maxports*maxcol*sizeof(video);
  rxback=(unsigned)((mem-(freekb+doslen)-portlines*maxline)/portlines-2);

  if(rxback>350)rxback=350;
  if((rxback<(maxline*2-2))||(mem<70000L)||miniram)
    rxback=(maxline*2+2);
  txback=maxline-2;

  if(wt->divline>(maxline-1))wt->divline=maxline-5;
  bildport=1;
  set_context(bildport);

  wnd=xwin;
  top[wnd]=0;
  bottom[wnd]=maxline;
  column[wnd]=0;
  line[wnd]=0;
  set_color(txcolor,0);
  cls();

  for(pnummer=0;pnummer<maxp;pnummer++)
  { set_context(pnummer);

    b->rxbufptr=(unsigned *)farmalloc(rxback*maxcol*sizeof(video));
    b->txbufptr=(unsigned *)farmalloc(txback*maxcol*sizeof(video));
    if(!(b->rxbufptr&&b->txbufptr) || (coreleft()<(freekb-2000)))
    { if(pnummer<2)
      {
	abortmsg="Out of memory";
	exit(1);
      }
      else
      { if(b->rxbufptr) farfree(b->rxbufptr);
	if(b->txbufptr) farfree(b->txbufptr);
	break;
      }
    }

    maxports=pnummer+1;
    wnd=txwin;
    set_color(txcolor,0);
    top[wnd]=b->cbufline=b->cbufcolumn=0;
    bottom[wnd]=wt->txwinlen-1;
    cls();

    wnd=rxwin;
    b->rbufcolumn=0;
    b->rbufline=top[wnd]=wt->txwinlen+1;
    bottom[wnd]=wt->divline-1;
    set_color(rxcolor,0);
    cls();
  }


  bildport=1;
  set_context(bildport);

  wnd=statln;
  top[wnd]=wt->txwinlen;
  bottom[wnd]=wt->txwinlen;
  cls();

  wnd=stat2;
  top[wnd]=wt->divline;
  bottom[wnd]=wt->divline;
  cls();

  set_context(0);
  top[monwin]=wt->divline+1;
  bottom[monwin]=maxline;
  set_color(monheader,0);
  wnd=monwin;
  cls();
  set_context(1);
  curwin=wnd=txwin;
  set_color(txcolor,0);
  cls();
  setzcurs(1);
}

/*---------------------------------------------------------------------------*/

void statst(int sofort)
{ long lwert=0;
  static int manchmal=0;
  int i;
  struct time uhr;
  struct date datum;
  int l1s;

  getdate(&datum);
  gettime(&uhr);
  unixtime=dostounix(&datum,&uhr);

  if(!bildein) return;

  if(!sofort || !((++manchmal)%5))
  {
    wnd=statln;
    set_color(stat1normal,1);
    column[wnd]=0;

    if((bfeld[0].stop&2) || (b->stop&2))
      set_color(stat1stop,1);
    else
      set_color(stat1normal,1);

    set_context(b->port);

    l1s=get_l1state();

    if(l1s&CH_DCD)
      putvs(" RECV ");
    else if(l1s&CH_PTT)
      putvs(" SEND ");
    else
      putvs(" QRV  ");

    set_color(stat1normal,1);
    putf("%s> ",get_mycall());
    putvs(lstext[get_lstate()]);
    while(column[wnd]<32)
      putv(' ');

    putf("%8.8s ",get_version());
    if(b->sendbuffer)
      putf("b=%4d",b->send_in-b->send_out);
    else
      putf("ln=%3d",rxback);
    putf(" n2=%2d o=%d ",get_retries(),get_outstanding());

    if(get_frack()==0)
      putf(" DAMA ");
    else
      putf("fr=%3d",get_frack());
    putf(" k=%2d ",get_channel());

    putf("%02d:%02d %d",uhr.ti_hour,uhr.ti_min,b->port);
    if(b->german==2)
    { att|=0x8000;
      putv('U');
      att&=0x7fff;
    }
    else
    {	if(b->german)
        putv('U');
      else
        putv(' ');
    }
    if(replace) putv('R'); else putv('I');
    putv(' ');
  }

  if(sofort || !((++manchmal)%5))
  {
    wnd=stat2;
    set_color(stat2idle,2);
    column[wnd]=0;

    for(i=1;i<maxports;i++)
    {
      set_tnc_context(i);

      set_color(stat2active,2);
      putf("%d:",i);
      if(i==b->port)  set_color(stat2on,2);
      if(get_lstate()==disconnected)
      { set_partner("");
	if(i!=b->port)
	{ if(bfeld[i].blinkon) set_color(stat1stop,2);
	  else                 set_color(stat2idle,2);
        }
	putvs("------");
      }
      else
      { if(bfeld[i].blinkon)
	  set_color(stat1stop,2);
	putvs(get_partner());
      }
      set_color(stat2active,2);
      putv(' ');
    }
    set_context(b->port);

    while(column[wnd]<65)
      putv(' ');
    if(b->file)
    { switch(b->filejob)
      { case stextfile:
	  putvs(" read");
	  break;
	case rtextfile:
	  putvs("write");
	  break;
	case vtextfile:
	  putvs(" view");
	  break;
	case etextfile:
	  putvs(" edit");
	  break;
	case sbinfile:
	  putvs(" rprg");
	  break;
	case rbinfile:
	  putvs(" wprg");
	  break;
	case rtext7plus:
	  putvs("7plus");
	  break;
      }
      fgetpos(b->file,&lwert);
      if(b->filelen)
      { switch(b->filejob)
        {
          case sbinfile: putf(": %ld%%",lwert*100/b->filelen);
                         break;
          case rbinfile: putf(": %ld%%",lwert*100/(b->filelen+lwert));
                         break;
          default:       putf(": %ld",lwert);               
        }
      }
      else
        putf(": %ld",lwert);
    }
    else
      putf("     BayCom");


    while(column[wnd]<maxcol-1)
      putv(' ');
    putv(' ');
  }
}

/*---------------------------------------------------------------------------*/

void winreorg(void)
{ int i;
  int psave=b->port;

  top[statln]=bottom[statln]=wt->txwinlen;
  top[rxwin]=wt->txwinlen+1;

  if(bildport)
  { top[stat2]=bottom[stat2]=wt->divline;
    top[monwin]=wt->divline+1;
  }
  else
  { top[stat2]=bottom[stat2]=top[statln]+1;
    top[monwin]=top[statln]+2;
  }

  for(i=0;i<WINDOWS;i++)
  { if(line[i]>bottom[i])line[i]=bottom[i];
    if(line[i]<top[i])line[i]=top[i];
    if(column[i]>=maxcol)column[i]=0;
  }
  for(i=1;i<maxports;i++)
  { set_context(i);
    if(b->rbufline>bottom[rxwin]) b->rbufline=bottom[rxwin];
    if(b->rbufline<top[rxwin])    b->rbufline=top[rxwin];
  }
  set_context(psave);
}

/*---------------------------------------------------------------------------*/

void screenrestore(void)
{ video *src;
  video *dest;
  int i;

  line[txwin]    = b->cbufline;
  column[txwin]  = b->cbufcolumn;

  line[rxwin]    = bfeld[bildport].rbufline;
  column[rxwin]  = bfeld[bildport].rbufcolumn;

  line[monwin]   = bfeld[0].rbufline;
  column[monwin] = bfeld[0].rbufcolumn;

  winreorg();

  for(i=0;i<=(bottom[monwin]-top[monwin]);i++)
  { src=bfeld[0].rxbufptr+maxcol*((bfeld[0].rxbufvideo+i)%rxback);
    dest=vram+maxcol*(top[monwin]+i);
    memmove(dest,src,2*maxcol);
  }
  if(bildport)
  { for(i=0;i<=(bottom[rxwin]-top[rxwin]);i++)
    { src=b->rxbufptr+maxcol*((b->rxbufvideo+i)%rxback);
      dest=vram+maxcol*(top[rxwin]+i);
      memmove(dest,src,2*maxcol);
    }
  }
  for(i=0;i<=(bottom[txwin]-top[txwin]);i++)
  { src=b->txbufptr+maxcol*((b->txbufvideo+i)%txback);
    dest=vram+maxcol*(top[txwin]+i);
    memmove(dest,src,2*maxcol);
  }
  statst(1);
  set_color(txcolor,0);
}

/*---------------------------------------------------------------------------*/

void screensave(void)
{ video *src;
  video *dest;
  int i;

  b->cbufline=line[txwin];
  b->cbufcolumn=column[txwin];
  bfeld[bildport].rbufline=line[rxwin];
  bfeld[bildport].rbufcolumn=column[rxwin];
  bfeld[0].rbufline=line[monwin];
  bfeld[0].rbufcolumn=column[monwin];

  for(i=0;i<=(bottom[monwin]-top[monwin]);i++)
  { dest=bfeld[0].rxbufptr+maxcol*((bfeld[0].rxbufvideo+i)%rxback);
    src=vram+maxcol*(top[monwin]+i);
    memmove(dest,src,2*maxcol);
  }
  if(bildport)
    for(i=0;i<=(bottom[rxwin]-top[rxwin]);i++)
    { dest=b->rxbufptr+maxcol*((b->rxbufvideo+i)%rxback);
      src=vram+maxcol*(top[rxwin]+i);
      memmove(dest,src,2*maxcol);
    }
  for(i=0;i<=(bottom[txwin]-top[txwin]);i++)
  { dest=b->txbufptr+maxcol*((b->txbufvideo+i)%txback);
    src=vram+maxcol*(top[txwin]+i);
    memmove(dest,src,2*maxcol);
  }
}

/*---------------------------------------------------------------------------*/

void curoben(void)
{
  if(curwin==rxwin)
  { b->rxbufvideo=xbufvideo;
    b->stop&=2;
    b->rbufline=xbufline;
    b->rbufcolumn=xbufcolumn;
  }
  if(curwin==monwin)
  { bfeld[0].rxbufvideo=xbufvideo;
    bfeld[0].stop&=2;
    bfeld[0].rbufline=xbufline;
    bfeld[0].rbufcolumn=xbufcolumn;
  }
  curwin=txwin;
}

/*---------------------------------------------------------------------------*/

void portset(int port)
{ screensave();
  curoben();
  if(port && !bildport)   /* von Monitor nach Port */
  { bfeld[0].rxbufvideo=(bfeld[0].rxbufvideo+(wt->divline-(top[statln]+1)))%rxback;
  }
  if(!port && bildport)   /* von Port nach Monitor */
  { bfeld[0].rxbufvideo=(bfeld[0].rxbufvideo+(rxback-(wt->divline-(top[statln]+1))))%rxback;
  }
  bildport=port;
  set_context(bildport);
  screenrestore();
  b->blinkon=0;
}

/*---------------------------------------------------------------------------*/

void inschar(int immer)
{ char i;
  video far *delptr=ladr;
  if(!replace || immer)
  { for(i=maxcol-1;i>column[wnd];--i)
      delptr[i]=delptr[i-1];
    delptr[column[wnd]]=att|' ';
  }
}

/*---------------------------------------------------------------------------*/

void delchar(void)
{ char i;
  video far *delptr=ladr;
  for(i=column[wnd];i<maxcol;i++)
   delptr[i]=delptr[i+1];
  delptr[maxcol-1]=att|' ';
}

/*---------------------------------------------------------------------------*/

void ctrlzeichen(char scancode,int vontaste,bool shift)
{ int i;

  /*
  if(shift) {
    if(beginBlock==NULL) {
      beginBlock=ladr+column[wnd];


  }
  */
  if((scancode>0x3a) && (scancode<(0x3a+maxports)))
    portset(scancode-0x3a);
  else if(!st_taste(scancode))
    switch(scancode)
    {
      case 8:
      { if(column[wnd])
	{ column[wnd]--;
	  delchar();
	}
      } break;

      case 75: // cursor left
      { if(column[wnd])column[wnd]--;
	else if(line[wnd]>top[wnd])
	{ line[wnd]--;
	  column[wnd]=maxcol-1;
	}
      } break;

      case 68:
      { portset(0);
      } break;

      case 71:
      { column[wnd]=0;
      } break;

      case 72:
      { if(line[wnd]>top[wnd])
	  line[wnd]--;
	else
	{ if(curwin==monwin)
	  { taskvar_t *bsave=b;
            set_context(0);
            bildport=0;
	    scrolldn(1);
            b=bsave;
	    bildport=b->port;
	  }
	  else scrolldn(1);
	}
      } break;


      case 77:
      { if(column[wnd]<(maxcol-1))column[wnd]++;
	else column[wnd]=0;
      } break;

      case 79:                                     /* ENDE */
      { i=maxcol-2;
	while((' '==(*(ladr+i)&255)) && i)i--;
	column[wnd]=i+1;
      } break;

      case 115:                                   /* Ctrl-Left */
      { i=column[wnd];
	if(i)i--;
	while((' '==(*(ladr+i)&255)) && i)i--;
	while((' '!=(*(ladr+i)&255)) && i)i--;
	if(' '==(*(ladr+i)&255))i++;
	column[wnd]=i;
      } break;

      case 116:                                   /* Ctrl-Right */
      { i=column[wnd];
	if(i<maxcol)i++;
	while((' '!=(*(ladr+i)&255)) && (i<maxcol))i++;
	while((' '==(*(ladr+i)&255)) && (i<maxcol))i++;
	column[wnd]=i;
      } break;

      case 13:
      { column[wnd]=0;
      } /* hier absichtlich kein break; */

      case 80:
      { if(line[wnd]<bottom[wnd])line[wnd]++;
	else
	{ if(curwin==monwin)
	  { taskvar_t *bsave=b;
            set_context(0);
            bildport=0;
	    scroll(scancode!=13);
            b=bsave;
	    bildport=b->port;
	  }
	  else scroll(scancode!=13);
	}
      } break;

      case 82:
      { replace=!replace;
      } break;

      case 83:
      { delchar();
      } break;

      case 73:
      { for(i=0;i<(bottom[curwin]-top[curwin]);i++)  /* pg down */
	  ctrlzeichen(72,0);
      } break;

      case 81:                                       /* pg up */
      { for(i=0;i<(bottom[curwin]-top[curwin]);i++)
	  ctrlzeichen(80,0);
      } break;

      case 67:
      { if(curwin==monwin) goto ganzoben;
	if(curwin==rxwin)  goto ganzunten;
	if(curwin==txwin)
	  if(bildport) goto mitte;
	  else         goto ganzunten;
      }

      case 104:                                       /* ALT-F1  */
      { puthelp(NULL);
      }

      case 120:
      { ganzoben:
	screensave();
	curoben();
	screenrestore();
      } break;

      case 121:
      { mitte:
	if(bildport)
	{ screensave();
	  curoben();
	  b->stop|=1;
	  xbufvideo=b->rxbufvideo;
	  xbufline=b->rbufline;
	  xbufcolumn=b->rbufcolumn;
	  curwin=rxwin;
	  b->rbufline=top[rxwin];
	  b->rbufcolumn=0;
	  screenrestore();
	}
      } break;


      case 122:
      { ganzunten:
	screensave();
	curoben();
        set_context(0);
	b->stop|=1;
	xbufvideo=  b->rxbufvideo;
	xbufline=   b->rbufline;
	xbufcolumn= b->rbufcolumn;
	curwin=monwin;
	b->rbufline=top[monwin];
	b->rbufcolumn=0;
        set_context(bildport);
	screenrestore();
      } break;


      case 132:   /* ctrl-rauf */
      { rxrauf:
	if(b->port && top[stat2]>top[statln]+2)
	{ video *src;
	  video *dest;
	  wnd=rxwin;
	  if(line[rxwin]!=top[rxwin])line[rxwin]--;
	  for(i=1;i<maxports;i++)
	  { set_context(i);
            scroll(0);
          }
	  if(curwin==rxwin) xbufvideo=(++xbufvideo)%rxback;
	  if(curwin==monwin)xbufvideo=(xbufvideo+(rxback-1))%rxback;

	  bottom[rxwin]--;
	  set_context(bildport);
	  bfeld[0].rxbufvideo=(bfeld[0].rxbufvideo+(rxback-1))%rxback;
	  src=bfeld[0].rxbufptr+maxcol*bfeld[0].rxbufvideo;
	  dest=vram+maxcol*(top[monwin]-1);
	  memmove(dest,src,2*maxcol);
	  wt->divline--;
	  winreorg();
	  statst(1);
	}
	else goto txrauf;
      } break;

      case 118:   /* ctrl-runter  */
      { rxrunter:
	if(b->port && top[stat2]!=maxline-1)
	{ video *src;
	  video *dest;

	  dest=bfeld[0].rxbufptr+maxcol*bfeld[0].rxbufvideo;
	  src=vram+maxcol*top[monwin];
	  memmove(dest,src,2*maxcol);
	  bfeld[0].rxbufvideo=(bfeld[0].rxbufvideo+1)%rxback;
	  wt->divline++;
	  if(line[monwin]==top[monwin])line[monwin]++;
	  bottom[rxwin]++;
	  wnd=rxwin;
	  set_color(rxcolor,0);
	  line[rxwin]++;
	  for(i=1;i<maxports;i++)
	  { set_context(i);
            scrolldn(0);
	    b->rbufline++;
	  }

	  if(curwin==rxwin)
	  { xbufvideo=(xbufvideo+(rxback-1))%rxback;   /* video zurck */
	    xbufline++;                            /* dafr Cursor vor */
	  }
	  if(curwin==monwin) xbufvideo=(xbufvideo+1)%rxback;

	  set_context(bildport);

	  winreorg();
	  statst(1);
	  if(scancode==117) goto txrunter;
	}
      } break;

      case 119:   /* ctrl-home */
      { txrauf:
	if(b->port && top[statln]>2)
	{ video *src;
	  video *dest;
	  wnd=txwin;
	  if(line[txwin]!=top[txwin])line[txwin]--;
	  for(i=0;i<maxports;i++)
	  { set_context(i);
            scroll(0);
          }
	  bottom[txwin]--;
	  for(i=1;i<maxports;i++)
	  { set_context(i);
            b->rxbufvideo=(b->rxbufvideo+(rxback-1))%rxback;
          }
	  if(curwin==rxwin)
	    xbufvideo=(xbufvideo+(rxback-1))%rxback;   /* video zurck */

	  set_context(bildport);
	  src=b->rxbufptr+maxcol*b->rxbufvideo;
	  dest=vram+maxcol*(top[rxwin]-1);
	  memmove(dest,src,2*maxcol);
	  wt->txwinlen--;
	  winreorg();
	  statst(0);
	  if(scancode==132) goto rxrauf;
	}
      } break;

      case 117:   /* ctrl-ende  */
      { txrunter:
	if(b->port && top[statln]!=top[stat2]-2)
	{ video *src;
	  video *dest;

	  dest=b->rxbufptr+maxcol*b->rxbufvideo;
	  src=vram+maxcol*top[rxwin];
	  memmove(dest,src,2*maxcol);

	  for(i=1;i<maxports;i++)
	  { set_context(i);
            b->rxbufvideo=(b->rxbufvideo+1)%rxback;
          }
	  if(curwin==rxwin) xbufvideo=(xbufvideo+1)%rxback;

	  wt->txwinlen++;
	  if(line[rxwin]==top[rxwin])line[rxwin]++;
	  bottom[txwin]++;
	  wnd=txwin;
	  set_color(txcolor,0);
	  line[txwin]++;
	  for(i=0;i<maxports;i++)
	  { set_context(i);
	    scrolldn(0);
	    if((i!=bildport) || (curwin==txwin))
	      b->cbufline++;
	  }

	  set_context(bildport);

	  winreorg();
	  statst(0);
	}
	else goto rxrunter;
      } break;

      case 15:                      /* shift-Tab */
      { b->stop^=2;
      } break;

      case 45:  // alt-x
      { /*
        int i,conn=0;
        for(i=1;i<maxports;i++)
        {
          set_tnc_context(i);
          if(get_lstate()!=disconnected)
            conn++;
        }
        set_tnc_context(b->port);
        if(conn)
        { wind wn;                                   // Fenster-Handle
          int att=wt->attr[colset+helpcolor];         // normales Attribut

          while(taste()) bioskey(0);
          screensave();
          setzcurs(-1);
          vseg=FP_SEG(vram);                         // Video-Segment setzen
          wn=wopen(20,10,32,6,NULL);            // Fenster vorbereiten
          wclear(wn,att);
          wframe(wn,att,"Terminal shutdown");
          wstr(wn,2,att,"Disconnect all streams (Y/N)?");
          while(!taste());
          int a=bioskey(0)&255;
          if(tolower(a)=='y' || tolower(a)=='j')
          { conn=0;
            tnc_disconnect(5);
          }
          wclose(wn);
          screenrestore();
          setzcurs(1);
        }
        if(conn==0)
        */
          prgende=TRUE;
      } break;

      case 22:
      { b->german=!b->german;
      } break;

      default:
      ;
    }
  wnd=(WND)curwin;
  if(vontaste) setzcurs(1);
}

/*---------------------------------------------------------------------------*/

void bildplatte(void)
{ FILE *bildfile;
  int i;
  int rxlines=wt->divline-(wt->txwinlen+1);
  screensave();
  bildfile=sysopen(VIDNAME,"wb");
  if(bildfile)
  { int ports=maxports-1;
    setvbuf(bildfile,NULL,_IOFBF,16384);
    fputc(wt->txwinlen,bildfile);
    fputc(wt->divline,bildfile);
    fputc(maxline,bildfile);
    fputc(ports,bildfile);
    fputc(bildport,bildfile);
    for(i=1;i<=ports;i++)
    { set_context(i);
      unsigned unten=(b->rxbufvideo+rxlines)%rxback;
      unsigned oben=b->rxbufvideo;
      fwrite(&b->rbufline  ,2,1,bildfile);
      fwrite(&b->rbufcolumn,2,1,bildfile);
      while(unten!=oben)
      { fwrite(b->rxbufptr+maxcol*oben,maxcol*sizeof(video),1,bildfile);
	oben=(++oben)%rxback;
      }
      unten=(b->txbufvideo+wt->txwinlen)%txback;
      oben=b->txbufvideo;
      fwrite(&b->cbufline,2,1,bildfile);
      fwrite(&b->cbufcolumn,2,1,bildfile);
      while(unten!=oben)
      { fwrite(b->txbufptr+maxcol*oben,maxcol*sizeof(video),1,bildfile);
	oben=(++oben)%txback;
      }
    }
    fclose(bildfile);
  }
}

/*---------------------------------------------------------------------------*/

int plattebild(void)
{ FILE *bildfile;
  int i;
  int selectport=-1;
  int rxlines=wt->divline-(wt->txwinlen+1);
  bildfile=sysopen(VIDNAME,"rb");
  if(bildfile)
  { setvbuf(bildfile,NULL,_IOFBF,16384);
    if(fgetc(bildfile)!=wt->txwinlen)
      goto nixmachen;
    if(fgetc(bildfile)!=wt->divline)
      goto nixmachen;

    if((fgetc(bildfile)==maxline))
    { int ports=fgetc(bildfile);
      selectport=fgetc(bildfile);
      if(ports>(maxports-1))
	ports=(maxports-1);
      if(selectport>=(maxports-1))
	selectport=(maxports-1);
      bildport=selectport;
      for(i=1;i<=ports;i++)
      { set_context(i);
        unsigned unten=(b->rxbufvideo+rxlines)%rxback;
	unsigned oben=b->rxbufvideo;
	fread(&b->rbufline,2,1,bildfile);
	fread(&b->rbufcolumn,2,1,bildfile);
	while(unten!=oben)
	{ fread(b->rxbufptr+maxcol*oben,maxcol*sizeof(video),1,bildfile);
	  oben=(++oben)%rxback;
	}
	unten=(b->txbufvideo+wt->txwinlen)%txback;
	oben=b->txbufvideo;
	fread(&b->cbufline,2,1,bildfile);
	fread(&b->cbufcolumn,2,1,bildfile);
	while(unten!=oben)
	{ fread(b->txbufptr+maxcol*oben,maxcol*sizeof(video),1,bildfile);
	  oben=(++oben)%txback;
	}
      }
    }
    else goto nixmachen;
    set_context(selectport);
    screenrestore();
    nixmachen:
    fclose(bildfile);
  }
  return selectport;
}

/*---------------------------------------------------------------------------*/

void screenoff(void)
// ************************************************************************
//
//    Bildschirmschoner
//
//    Es wird geprft, ob lngere Zeit nichts geschehen ist und wenn ja,
//    dann wird mit einer Zufallsfolge der Bildschim gelscht und bei
//    Connect oder Tastendruck wieder aufgebaut
//
// ************************************************************************
{ static int tst;                         // zum merken von SHIFT etc
  static int mausz;
  static int maussp;
  static long baycomtime;

  int i;

  if(!bildein)                            // Bildschirm ist aus
  { unsigned ch;
    static int pos=0;
    static char *baycomtxt="BayCom";
    for(i=0;i<50;i++)                     // 50mal auf einmal
    { switch(random(1000))                // Wahrscheinlichkeit 1/1000
      { case 0:
	case 1:  ch=0x072e; break;        // dunkler Punkt
	case 2:  ch=0x0f2e; break;        // heller Punkt
	case 3:  ch=0x0f2a; break;        // heller Stern
	default: ch=0x0720;               // Bildpunkt schwarz
      }
      vram[random((maxcol+1)*(maxline+1))]=ch;   // Bildpunkt schreiben
    }
    if(unixtime > (baycomtime+9))
    { pos=random((maxcol+1)*(maxline+1));
      baycomtime=unixtime;
    }
    if(unixtime < (baycomtime+2))
    { for(i=0;i<6;i++)
      { if(!colset)
	  vram[pos+i]=baycomtxt[i]+0x0700;
	else
	  vram[pos+i]=baycomtxt[i]+((i&1)?0x0900:0x0700);
      }
    }
    delay(50);                      // Verzgerung unabhngig vom Rechnertakt
    if((bioskey(2)!=tst)||taste())  // SHIFT oder CTRL gedrckt
      screenon();                   // dann Schirm einschalten
    if((mausz!=mauszeile()) || (maussp!=mausspalte()))
      screenon();
  }
  else if(tastentime&&wt->crtsave&&bildport)    // Zeit luft, CRTSAVE aktiv
  { if(((unixtime-tastentime)/60)>wt->crtsave)  // Zeit abgelaufen
    { mausaus();
      screensave();
      bildein=0;                               // Flag merken
      setzcurs(-1);                            // Cursor unsichtbar
      tst=bioskey(2);                          // SHIFT etc. merken
      mausz=mauszeile();
      maussp=mausspalte();
    }
  }

  taskvar_t *bsave=b;
  for(i=0;i<maxports;i++)                   // Ports durchsehen
  { set_context(i);
    if(get_lstate()>disconnected)       // isser connected?
      screenon();                              // dann Schirm einschalten
  }
  b=bsave;
}

/*---------------------------------------------------------------------------*/

void screenon(void)
// ************************************************************************
//
//    Schaltet Bildschirm wieder ein nach Tastendruck oder Connect
//
//    Ist der Bildschirm ein, so wird nur der Timer neu gestartet
//
// ************************************************************************
{ tastentime=unixtime;
  if(!bildein)                            // ist der Schirm aus?
  { bildein=1;                            // dann einschalten
    screenrestore();                      // aus dem Speicher zurckholen
    setzcurs(1);                          // Cursor wieder sichtbar
    mausein();
  }
}
