/***************************************************************

  BayCom(R)           Packet-Radio fuer IBM PC

  BayCom-Terminal


  ---------------------------------------------
  Unterfunktionen fuer Benutzerein- und Ausgabe
  ---------------------------------------------


  Copyright (C) 1999 Flori Radlherr, DL8MBT, flori@baycom.org
      
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ***************************************************************/


#include "bct.h"


char globalpath[80];

/*---------------------------------------------------------------------------*/

void filepath(char *name,char *filename)
{ if((name[0]=='\\') || (name[1]==':'))
    strcpy(filename,name);
  else
  { strcpy(filename,globalpath);
    strcat(filename,name);
  }
}

/*---------------------------------------------------------------------------*/

FILE *sysopen(char *name,char *mode)
{ char filename[80];
  filepath(name,filename);
  return fopen(filename,mode);
}

/*---------------------------------------------------------------------------*/

char *syspath(char *name)
{ static char filename[80];
  filepath(name,filename);
  return filename;
}

/*---------------------------------------------------------------------------*/

void subst(char *s,char i,char j)
{  while((s=strchr(s,i))!=NULL)
    s[0]=j;
}


/*---------------------------------------------------------------------------*/

void fixpath(void)
{ //Deti 04/96
  char *s;
  if((s=getenv("BCT"))!=NULL)
  { char tmp[80];
    strcpy(tmp,s);
    subst(tmp,'/','\\');
    _fullpath(globalpath,tmp,79);

    if(access(globalpath,0))
    {
      printf("Invalid environment setting: bct=%s",s);
      getch();
      goto lab;
    }

    strcat(globalpath,"\\");
  }
  else
  {
    lab:;
    int i=0;
    memset(globalpath,0,sizeof(globalpath));
    char *env=environ[0];
    while(env[i] || env[i+1]) i++;
    env+=(i+4);
    i=0;
    while(env[i]) i++;
    while(env[i]!='\\') i--;
    for(;i+1;i--)
      globalpath[i]=env[i];
  }
}

/*---------------------------------------------------------------------------*/

void putvs(char *string)
{ while(*string)
    putv(*(string++));
}


/*---------------------------------------------------------------------------*/

void putf(char *format, ...)
{ va_list argpoint;
  char cbuf[100];

  va_start(argpoint,format);
  vsprintf(cbuf,format,argpoint);
  va_end(argpoint);

  putvs(cbuf);
}

/*---------------------------------------------------------------------------*/

int blkill(char *bf)
{ int i=0;
  while(bf[i]==13 || bf[i]==' ' || bf[i]==',') i++;
  return i;
}

/*---------------------------------------------------------------------------*/

int nextdez(char **bf)
{ int i=-1;
  int a=0;

  if(!(**bf)) return -1;
  while(**bf && ((**bf<'0')||(**bf>'9'))) (*bf)++;
  if(!(**bf)) return -1;
  i=atoi(*bf);
  while((**bf>='0') && (**bf<='9'))
  { (*bf)++;
    a++;
  }
  (*bf)+=blkill(*bf);
  if(a) return i;
  else  return -1;
}



/*---------------------------------------------------------------------------*/

int readcmd(char *beftab[],char **buffer,int minimum)
// *********************************************************************
// 
//   vergleicht die Kommandos in einer Befehlstabelle mit einem
//   Stringanfang. Wird das Kommando gefunden, so wird der String-
//   zeiger entsprechend nachgefuehrt.
// 
//   beftab[] = Pointer-Array, dessen Eintraege auf die Befehls-Strings
//              zeigen. Das Array mu an letzter Stelle stets mit
//              dem NULL-Pointer besetzt sein.
//   *buffer    Zeiger auf einen String, in dem am Anfang der Befehl
//              steht.
//   minimum    Gibt die Anzahl der mindestens bereinstimmenden
//              Zeichen an, damit ein Befehl als solcher akzeptiert
//              wird.
//              0 bedeutet, dass der Befehl stets mit String-Ende (\0)
//              oder mit einem Blank abgeschlossen sein muss (fuer Node)
//
// *********************************************************************
{ int i=0,j=0,cmd=0,maxcmd=0;
  while(beftab[i])
  { j=0;
    while(beftab[i][j] && (toupper(buffer[0][j])==beftab[i][j]))j++;
    i++;
    if((j>maxcmd)&&(j>=minimum))
    { // if(minimum || (buffer[0][j]==0) || (buffer[0][j]==' '))
      if((buffer[0][j]==0) || (buffer[0][j]==' '))
      { maxcmd=j;
        cmd=i;
      }
    }
  }
  *buffer+=maxcmd;
  *buffer+=blkill(*buffer);
  return cmd;
}


/*---------------------------------------------------------------------------*/

char *putzeit(long unsigned zeit)
{ long unsigned hours=zeit/360;
  long unsigned days=hours/24;
  static char s[12];

  s[0]=0;
  if(days>99)
    sprintf(s,"-:--");
  else
  { zeit-=hours*360;
    hours-=days*24;

    if(days)
      sprintf(s,"%lu.",days);
    sprintf(s+strlen(s),"%02lu:%02lu",hours,zeit/6);
  }
  return s;
}

/*---------------------------------------------------------------------------*/

char *modifymask(char *mask)
{ struct ffblk direntry;
  char drive[MAXDRIVE];
  char dir[MAXDIR];
  char file[MAXFILE];
  char ext[MAXEXT];
  int flags;
  int exist=(findfirst(mask,&direntry,0)==0);
  flags=fnsplit(mask,drive,dir,file,ext);

  if(drive[0]==0)
  { drive[0]=getdisk()+'A';
    drive[1]=':';
    drive[2]=0;
  }

  if(exist==0)
  { if(!strchr(mask,'*') && (findfirst(mask,&direntry,FA_DIREC)==0))
    { strcat(dir,file);
      strcat(dir,"\\");
      strcpy(file,"*");
      strcpy(ext,".*");
      flags|=DIRECTORY;
    }
    else
    { if(!(flags & FILENAME))   strcpy(file,"*");
      if(!(flags & EXTENSION))  strcpy(ext,".*");
    }
  }

  if(dir[0]!='\\')
  { char curdir[MAXDIR];
    curdir[0]='\\';
    if(getcurdir(drive[0]-'@',curdir+1)==0)
    { if(curdir[strlen(curdir)-1]!='\\')
	strcat(curdir,"\\");
      strcat(curdir,dir);
      strcpy(dir,curdir);
    }
  }

  fnmerge(mask,drive,dir,file,ext);
  strupr(mask);
  return mask;
}


/*---------------------------------------------------------------------------*/

//
//  mode = 0 1 :  Datum / Uhrzeit
//  mode = 2 3 :  Filename / ext / Filegre
//
//  gerade: findfirst  ungerade=findnext
//
char *dirline(char *mask,int mode)
{ static struct ffblk direntry;
  static char line[60];
  char *ext;

  do
  { if((mode&1)==0)
    { if((-1)==findfirst(mask,&direntry,0xffff))
        return NULL;
    }
    else
    { if((-1)==findnext(&direntry))
        return NULL;
    }
    line[0]=0;

    switch(mode&6)
    { case 2:
        ext=strchr(direntry.ff_name,'.');
        if(ext>direntry.ff_name)
          ext[0]=0;
        else
          ext=".";

        if(direntry.ff_attrib&FA_DIREC)
          sprintf(line,"%-8s %-3s <DIR>    ",direntry.ff_name,ext+1);
        else
          sprintf(line,"%-8s %-3s %8lu ",direntry.ff_name,ext+1,
                                         direntry.ff_fsize);

      case 0:
        sprintf(line+strlen(line),"%02d.%02d.%02d %02d:%02d",
          direntry.ff_fdate&31,
          (direntry.ff_fdate>>5)&15,
          ((direntry.ff_fdate>>9)+80)%100,
          (direntry.ff_ftime>>11),
          (direntry.ff_ftime>>5)&63);
      break;

    }
    mode|=1;
  }
  while(direntry.ff_name[0]=='.');
  return line;
}
