/***************************************************************

  BayCom(R)           Packet-Radio Terminal for DOS

  BayCom-Terminal

  
  ---------------------
  Terminal Main Program
  ---------------------

  
  Copyright (C) 1999 Flori Radlherr, DL8MBT, flori@baycom.org
      
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ***************************************************************/

#include "bct.h"
#include "l2host.h"

/*---------------------------------------------------------------------------*/

#define DOSOUT "dos_out.$$$"
#define DOSERR "dos_err.$$$"
#define NIX 3

/*---------------------------------------------------------------------------*/

// 
//  some dirty globals...
// 
int  uninit=1;
char cbuf[600];       // many purposes :(
char st[MAXSTLEN];

/*---------------------------------------------------------------------------*/

taskvar_t   bfeld[MAXTERMPORTS];
taskvar_t   *b;
term_para_t *wt;
char    mycall[10][12];
int     mynum=0;

int     doppunkt;
int     nol1par=0,autobin=0;

/*---------------------------------------------------------------------------*/

void doopen(void);

/*---------------------------------------------------------------------------*/

// dealing with names of QSO-partners
// File: names.bct
// Format:   "<call> <name>\n"

char *getname(char *call)
{ 
#define CACHESZ 32
  FILE *f;
  static char name[30];
  char call1[10];
  char s[51];
  int i=0;
  static char namecache[CACHESZ][30];
  static char callcache[CACHESZ][7];
  static int cachepos=0;

  strcpy(s,call);
  strupr(s);
  while(isalnum(s[i]))i++; s[i]=0;
  sprintf(call1,"%-6.6s",s);
  for(i=0;i<CACHESZ;i++)
  { if(strcmp(call1,callcache[i])==0)
      return namecache[i];
  }
  name[0]=0;

  f=fopen(syspath("names.bct"),"rt");
  if(f)
  { setvbuf(f,NULL,_IOFBF,16384U);
    while(fgets(s,50,f)!=NULL)
    { if(strncmp(s,call1,6)==0)
      { s[strlen(s)-1]=0;
        sscanf(s,"%s %29s",call1,name);
        strcpy(namecache[cachepos],name);
        strcpy(callcache[cachepos],call1);
        cachepos=(cachepos+1)%CACHESZ;
        break;
      }
    }
    fclose(f);
  }
  return name;
}

/*---------------------------------------------------------------------------*/

void set_context(int port)
{ b=&bfeld[port];
  set_stream(port);
}

/*---------------------------------------------------------------------------*/

void set_tnc_context(int port)
{ set_stream(port);
}

/*---------------------------------------------------------------------------*/

void crc(int ch,unsigned *word)
{ int hibit;
  int shift;

  for (shift=0x80; shift; shift >>= 1)
  { hibit = *word & 0x8000;
    *word <<= 1;
    *word |= (ch & shift ? 1 : 0);
    if (hibit)
      *word ^= 0x1021;
  }
}

/*---------------------------------------------------------------------------*/

char ibmansi(char zeichen)
{ char *a=strchr("\0",zeichen);
  if(a)return *(a+8);
  else return zeichen;
}

/*---------------------------------------------------------------------------*/

char ansiibm(char zeichen)
{ char *a=strchr("\0",zeichen);

  if(a)return *(a+8);
  else return zeichen;
}

/*---------------------------------------------------------------------------*/

int putprompt(int ins)
{ if(ins)
    inschar(1);
  putv(':');
  return 1;
}

/*---------------------------------------------------------------------------*/

int getprompt(char *buf)
{ int i=0;
  if(strstr(buf,"cmd:") == buf)
    return 4;
  while(buf[i]==':') i++;
    return i;
}

/*---------------------------------------------------------------------------*/

int getlprompt(video far *buf)
{ int i=0;
  char *cmd="cmd:";

  while((buf[i]&255)==cmd[i]) i++;
  if(i==4)
    return 4;
  i=0;
  while((buf[i]&255)==':') i++;
    return i;
}

/*---------------------------------------------------------------------------*/

void doclose(void)
{ critical_error=0;
  if(b->filejob)
    fclose(b->file);
  b->file=NULL;
  b->filename[0]=0;
  switch(b->filedos)
  { case 1:  unlink(DOSOUT);
             b->filedos=0;
    default: b->filejob=nofile;
  }
}

/*---------------------------------------------------------------------------*/

void doopen(void)
{ if((b->filejob==nofile) && b->defaultfilename[0])
  { strcpy(b->filename,b->defaultfilename);
    b->filejob=rtextfile;
  }

  if(b->filejob!=nofile)
  { char *option;
    switch(b->filejob)
    { case stextfile:
      case vtextfile: option="rt"; break;
      case sbinfile:  option="rb"; break;
      case etextfile:
      case rtext7plus:
      case rtextfile: option="at"; break;
      case rbinfile:  option="ab"; break;
    }
    if(get_lstate()==disconnected)
    {
      switch(b->filejob)
      { case stextfile:
        case sbinfile:
        case rbinfile:
             b->filename[0]=0;
             b->filejob=nofile;
      }
    }

    b->file=fopen(b->filename,option);
    if(!b->file)
    { b->filename[0]=0;
      b->filejob=nofile;
    }
    else
    { 
      if(b->filepos)
	fseek(b->file,b->filepos,SEEK_SET);
      else
	fseek(b->file,0,SEEK_END);
    }
  }
}

/*---------------------------------------------------------------------------*/

void einmeldung(int setup)
{ putf("BayCom User-Terminal Version "VNUMMER
       "  (C) "YEAR" Florian Radlherr DL8MBT et al\r");
  putf("\rFlexNet interface version for free amateur radio usage ONLY\r");
}

/*---------------------------------------------------------------------------*/

void dofile(char *befbuf,char *ftyp,int i)
{ static char
    *m1=">>> file closed: ",
    *m2=">>> unable to open file\r",
    *m3=">>> no file open\r",
    *m4=">>> file open: ",
    *m5=">>> file exists...\r",
    *m6=">>> overwrite y/n > ";

  char buf2[40];
  int dos=0;
  int defaultfile=0;

  if(strcmp(befbuf,DOSOUT)==0)
    dos=1;

  if(*befbuf)
  {
    if(b->file)
    { if(!dos)
      { putvs(m1);
        putvs(b->filename);
        putv(13);
      }
      doclose();
    }

    b->filepos=0;
    if(strcmpi(befbuf,"off")&&strcmpi(befbuf,"aus"))
      strupr(befbuf);
    else if(b->defaultfilename[0])
    { strcpy(befbuf,b->defaultfilename);
      i=rtextfile;
      ftyp="at";
      defaultfile=1;
    }
    else
      befbuf[0]=0;

    if(remotefl && !b->pwok && befbuf[0] && !dos && !defaultfile)
    { int l=strlen(befbuf);

      while(l && befbuf[l-1]!='\\' && befbuf[l-1]!='/' && befbuf[l-1]!=':')
        l--;
      sprintf(buf2,"%s\\%s",syspath("remote"),befbuf+l);
      mkdir(syspath("remote"));
      befbuf=buf2;
    }

    if(befbuf[0])
    { if(strlen(befbuf)>=FNLEN) befbuf[FNLEN-1]=0;
      strcpy(b->filename,befbuf);
      if((ftyp[0]=='w') && (ftyp[1]=='b'))
      { FILE *f=fopen(befbuf,"rb");
	int a;
	if(f)
	{ //Deti 04/96
          if(autobin)
            b->file=fopen(befbuf,ftyp);
          else if(remotefl)
	    putf(m5);
	  else
	  { putf(m6);
	    setzcurs(1);
	    a=bioskey(0)&255;
	    if((a=='j') || (a=='y'))
	      b->file=fopen(befbuf,ftyp);
	    putf("%c\r",a);
	  }
	  fclose(f);
	}
	else
	  b->file=fopen(befbuf,ftyp);
      }
      else
	b->file=fopen(befbuf,ftyp);
      if(b->file)
      { if(wt->autobin && (ftyp[0]=='r') && (ftyp[1]=='b'))
	{ long ft;

	  getftime(fileno(b->file),(struct ftime *)&ft);
	  tnc_putf("#BIN#%ld#$%08lX#%s\r",
	    (b->filelen=filelength(fileno(b->file))),ft,befbuf);
	  tnc_flush();
	}
	if(wt->autobin && (ftyp[0]=='w') && (ftyp[1]=='b'))
        { b->waitbin=1;
        }
	b->crcword=0;
	if(ftyp[0]=='a')
	  fseek(b->file,0,SEEK_END);
	b->filejob=i;
	goto fileopen;
      }
      else
      { putvs(m2);
	doopen();
      }
    }
  }
  else
  { if(!b->file)
    { nofileopen:
      putvs(m3);
      doopen();
    }
    else
    { fileopen:
      if(dos)
        b->filedos=1;
      else
      { if(!remotefl || ftyp[0]!='r')
        { putvs(m4);
          putvs(b->filename);
          putv(13);
        }
      }
    }
  }
}

void tnc_buffer(char c)
{ if(b->port==0)
    tnc_put(c);
  else
  {
    if(!b->sendbuffer)
    { b->sendbuffer=(char *)malloc(8192);
      b->send_in=0;
      b->send_out=0;
    }
    if(!b->sendbuffer)
    { tnc_put(c);
      return;
    }
    b->sendbuffer[b->send_in]=c;
    if(b->send_in>8191)
      putf("*** tnc busy - line ignored\r");
    else
      b->send_in++;
  }
}

// ***************************************************************
// * kurzes File aussenden, ohne Echo und ohne Buffer-Begrenzung!
// ***************************************************************

void outfile(char *fname)
{ FILE *f=fopen(fname,"rt");
  int ch;

  if(f)
  { while((EOF!=(ch=fgetc(f))))
    { if(ch!=10)
      { if(ch!=13)
	  tnc_buffer(ch);
      }
      else
      { tnc_buffer(13);             // Return aussenden
      }
    }
    fclose(f);
  }
}

char *stristr(char *s1,char *s2)
// *****************************************************************
//
//  Sucht nach einem Teilstring in einem String.
//  Die Funktion ist analog zur Bibliotheksfunktion strstr,
//  unterscheidet aber nicht zwischen Gro- und Kleinschreibung
//
// *****************************************************************
{ int i;
  int l=strlen(s2);

  while(s1[0])
  { i=0;
    while((((s1[i]^s2[i])&0x5f)==0) && s2[i])
      i++;
    if(i==l)
      return s1;
    s1++;
  }
  return NULL;
}

/*---------------------------------------------------------------------------*/

//Deti 04/96
int get_password(char *call,char *buffer,int maxlen,int userpw,int rmnc)
// *********************************************************************
//
//  search in password file for appropriate box or node call and return
//  the corresponding password string entry
//
// *********************************************************************
{ int found=0;
  int pwnum=1;
  int str=0;

  FILE *f=sysopen(PWDNAME,"rt");
  if(f)
  { while(fgets(buffer,maxlen-1,f))
    { int i=strlen(buffer)-1;
      str =!!strchr(buffer,'*');
      if(strchr(buffer,'+'))         // is it a user-pw
      { if(!userpw)                  // yes, do not use as sysop-pw
          continue;
      }
      else if(rmnc && !strchr(buffer,'-')) //Deti 04/96
        continue;
      else
      {
        if(userpw)                  // no, only use as sysop-pw
          continue;
      }

      while(i && !isalnum(buffer[i])) i--;  // remove line feed etc
      buffer[i+1]=0;

      if(stristr(call,buffer)==call)        // call matches
      { if(str)
          pwnum=5;
        found=1;
        break;
      }
    }
    if(!found)
    { if(userpw)
      { fclose(f);
        return 0;
      }
      else
        fseek(f,0,SEEK_SET);         // no hit -> return default
    }
    if(!fgets(buffer,maxlen-1,f))            // password string
      pwnum=0;
    fclose(f);
    return pwnum;
  }
  return 0;
}

/*---------------------------------------------------------------------------*/

int putpass(char *befbuf,int rmnc)
{
  int i=0;
  int zahl=0;
  int n[5];
  char reference[90];
  char xnum[8];
  
  //Deti 04/96
  int pwnum=get_password(get_partner(),reference,90,!b->pwscharf,rmnc);

  if(rmnc) putf("\r");
  putf(">>> Send PW: Found=%d Flex=%d Input=%d\r",pwnum,rmnc,b->pwscharf);

  if(!pwnum) return 0;

  if(rmnc)
  { char *klz=strstr(befbuf,") ");
    if(strlen(reference)>7 || !klz) return 0;
    sprintf(xnum,"%05ld",atol(klz+2));
    for(i=0;i<5;i++)
    { if(xnum[i])
      zahl+=(xnum[i]-'0') * (reference[i]-'0');
    }
    tnc_putf("%d",zahl);
  }
  else
  { int rndpos;
    randomize();
    if(pwnum>5) pwnum=5;
    if(pwnum<1) pwnum=1;
    rndpos=random(pwnum)+1;

    i=strlen(befbuf)-5;
    while(i>0 && (isdigit(befbuf[i]) || befbuf[i]==' ')) i--;
    if(i>4 && i<60 && (befbuf[i]=='>'))
    { if(sscanf(befbuf+i+1,"%d%d%d%d%d",n,n+1,n+2,n+3,n+4)==5)
      { int block;
        for(block=1;block<=pwnum;block++)
        { for(i=0;i<5;i++)
            tnc_put(reference[(block==rndpos)?
                            (n[i]-1):random(strlen(reference)-1)]);
        }
      }
      else return 0;
    }
    else return 0;
  }
  tnc_put('\r');
  tnc_flush();
  return 1;
}

/*---------------------------------------------------------------------------*/

time_t filetime(char *name)
{ struct ffblk f;
  struct time t;
  struct date d;

  if(findfirst(name,&f,0xffff)==0)
  { d.da_day=f.ff_fdate&31;
    d.da_mon=(f.ff_fdate>>5)&15;
    d.da_year=((f.ff_fdate>>9)+1980);
    t.ti_hour=(f.ff_ftime>>11);
    t.ti_min=(f.ff_ftime>>5)&63;
    t.ti_hund=t.ti_sec=0;
    return dostounix(&d,&t);
  }
  else
  { return 0L;
  }
}

unsigned long dfree(char *path,int total)
{ struct dfree free;
  int drive;

  if(path[1]==':')
    drive=path[0]-'A';
  else
    drive=getdisk();

  getdfree(drive+1,&free);
  if(free.df_sclus!=0xFFFF)
  { if(total)
      return (long)free.df_total*(long)free.df_bsec*(long)free.df_sclus;
    else
      return (long)free.df_avail*(long)free.df_bsec*(long)free.df_sclus;
  }
  else
    return 0;
}

/*---------------------------------------------------------------------------*/

int isMailbox(char *call)
{
  if(strstr(call,"DB0")==call)
    return 1;
  if(strstr(call,"-8"))
    return 1;
  return 0;
}

/*---------------------------------------------------------------------------*/

int chatter(char *befbuf)
{ char *response=NULL;
  char chatnummer=*befbuf;

  if(remotefl && (toupper(chatnummer)=='E'))
    chatnummer=b->port+48;
  if((chatnummer<'0') || (chatnummer>'9'))
    return 0;
  if(chatnummer=='7' && toupper(befbuf[1])=='P')   // Sonderlocke
    return 0;
  chatnummer-=48;
  doppunkt=0;

  char partner_save[10];
  int oldpnum=b->port;
  strcpy(partner_save,get_partner());

  taskvar_t *bsave=b;               // change context to chat partner
  set_context(chatnummer);
  if(remotefl && isMailbox(get_partner())) {
    response="\r>>> permission denied.\r";
  }
  else if(get_lstate()<info_transfer) {
    response="\r>>> invalid port or user disconnected\r";
  }
  else
  { if(remotefl && (toupper(befbuf[0])!='E'))
    { tnc_putf("%s(%d):\r",partner_save,oldpnum);
    }
    befbuf+=(blkill(befbuf+1)+1);
    tnc_putf("%s\r",befbuf);
    tnc_flush();
  }
  set_context(bsave->port);
  if(response) {
    putvs(response);
  }
  return 1;
}

/*---------------------------------------------------------------------------*/

char *te_link(char *call)
{
  static char k[3];
  int i;
  k[0]=0;
  for(i=0;wt->linkcall[i][0];i++)
  {
    if(strstr(call,wt->linkcall[i])==call)
    { sprintf(k,"%d",wt->linkkanal[i]);
      break;
    }
  }
  return k;
}

/*---------------------------------------------------------------------------*/

void te_connect(char *mycall,char *path)
{ char call[10] ="",
       digi1[10]="",
       digi2[10]="",
       digi3[10]="",
       digi4[10]="",
       newpath[70];

  strupr(path);
  sscanf(path,"%s %s %s %s %s",call,digi1,digi2,digi3,digi4);
  if(call[0]==0)
    strcpy(call,wt->defdigi);
  if(digi1[0]==0)
  { sprintf(newpath,"%s %s ",call,te_link(call));
    if(stricmp(call,wt->defdigi)!=0 && te_link(call)[0]==0)
      sprintf(newpath,"%s %s %s",call,te_link(wt->defdigi),wt->defdigi);
  }
  else if(strlen(digi1)<3)
    strcpy(newpath,path);
  else
    sprintf(newpath,"%s %s %s %s %s %s",call,te_link(digi1),
                                        digi1,digi2,digi3,digi4);
  tnc_connect(mycall,newpath);
}

/*---------------------------------------------------------------------------*/

void beftest(char *befbuf)
{ int i=0,j=0,k;

  static char *tbeftab[]=
  { "OSHELL","O2SHELL","KANAL","INFO","CONNECT","XCONNECT",
    "DISCON","QUIT","USERS","CSTATUS","MHEARD",
    "EDIT","VIEW","READ","RPRG","WRITE","WPRG",
    "CLEAR","CLS","VERSION","HELP","J","SATTRIB","SYSTEM",
    "ST","LIST","DIR","CATALOG","CD","DIST",
    "RUN","RTT","PRIV","Z","NAME",
    NULL
  };

  enum befnum
    { unsinn,
      o,o2,kk,ii,c,x,
      d,q,u,cs,mh,
      e,v,r,rp,ww,wp,
      cl,xcl,ve,h,jj,sa,exit,
      st,list,dir,catalog,cd,dist,
      run,rtt,priv,zz,name
    }cmd=unsinn;

  if(chatter(befbuf)) return;

  if(remotefl)
  { putv('/');
    putv(0);
    putv('/');
  }

  befbuf+=blkill(befbuf);
  if(!(*befbuf)) return;     /* kein Kommando eingegeben */

  cmd=(befnum)readcmd(tbeftab,&befbuf,0);
  if(cmd!=st)
    strupr(befbuf);
  else
    befbuf[0]=toupper(befbuf[0]);

  if(cmd==unsinn)
  {
    for(i=0;i<79;i++)
      cbuf[i]=befbuf[i];
    setup(cbuf,1);
    setuprun=0;
    if(cbuf[0])
      putvs(cbuf);
    else
      putln("\r>>> invalid command, try :help");
    return;
  }

  if((cmd==kk)&&(!befbuf[0]))
  { putvs("K     \r");
    doppunkt=0;
    return;
  }
  putvs(tbeftab[cmd-1]);

  if(!remotefl)
  { putf("%50s","");
    column[wnd]=strlen(tbeftab[cmd-1])+2;
  }
  else
    putv(' ');

  putvs(befbuf);
  crlf();

  switch(cmd)
  { case exit:
    { prgende=TRUE;
    } break;

    case kk:
      set_channel(nextdez(&befbuf));
      break;

    case h:
    { 
      if(remotefl) {
	putln("\r>>> remote help not available");
      }
      else
	puthelp(befbuf);
    } break;

    case ii:
    {
      if(remotefl)
	outfile(syspath("info.bct"));
      else
	dofile(syspath("info.bct"),"rt",vtextfile);
    } break;

    case run:
    case o2:
    case zz:
    case o:
    { int bef=befbuf[0];
      static int val=0;

      flushall();

      if(cmd==run)
      { if(strchr(befbuf,'\\'))
          break;
        strcpy(cbuf,syspath(""));
	strcat(cbuf,"RUN\\");
      }
      else
	cbuf[0]=0;
      strcat(cbuf,befbuf);

      if(remotefl || (cmd!=o))
      { if(bef)
	{ freopen(DOSERR,"wt",stderr);
	  freopen(DOSOUT,"wt",stdout);
	  if((val=system(cbuf))==0)
	  { freopen("con","wt",stderr);
	    freopen("con","wt",stdout);
            { FILE *f=fopen(DOSERR,"rt");
              if(f)
              { while(fgets(cbuf,80,f))
                { cbuf[strlen(cbuf)-1]='\r';
                  putf("%s",cbuf);
                }
                fclose(f);
              }
              unlink(DOSERR);
            }
            if(filetime(DOSOUT))
	      dofile(DOSOUT,"rt",remotefl?stextfile:vtextfile);
	  }
	}
      }
      else
      { screensave();
	wnd=xwin;
	cls();
	dosvideo();
	if(!bef)
	{
	  printf("Type EXIT to return to BayCom terminal...");
	}
	val=system(befbuf);
	if(bef && val==0)
	{
	  printf("\rPress a key -> ");
	  while(!taste());
	  bioskey(0);
	  printf("\r                \r");
	}
	dosabspeichern(2);
	sccvideo();
	screenrestore();
        wnd=(WND)curwin;
      }
      if(val!=0)
      {
	putf(">>> can't open DOS shell\r");
      }
    } break;

    case mh:
    { 
      /*
      if(remotefl)
	domh(befbuf);
      else
      { screensave();
	wnd=xwin;
	cls();
	domh(befbuf);
	putf("\rPress a key -> ");
	setzcurs(-1);
	while(!taste());
	bioskey(0);
	screenrestore();
      }
      */
    } break;

    case cs:
    case u:
    { putf("Port Ch  Status         Call\r");

      for(i=1;i<maxports;i++)
      {
        char s[80];

        set_tnc_context(i);
	if(get_lstate()>disconnected)
	{ sprintf(s,"%3d ",i);
	  sprintf(s+strlen(s),"%3d",get_channel());
	  sprintf(s+strlen(s),"  %s %s",lstext[get_lstate()],get_mycall());
	  if(get_outgoing())
	    strcat(s," > ");
	  else
	    strcat(s," < ");
          sprintf(s+strlen(s),"%s",get_partner());
          set_tnc_context(b->port);
          putf("%s\r",s);
	}
      }
    } break;

    case ve:
      einmeldung(1);
      break;

    case jj:
    { if(remotefl)
      { int i,j;
        FILE *pwf=sysopen(PWDNAME,"rt");
        char pwstring[90];

        if(pwf)
	{ fgets(pwstring,89,pwf);
          fclose(pwf);

          randomize();
	  putf("%s> ",get_mycall());
	  for(i=0;i<5;i++)
	  { j=random(80)+1;
	    putf(" %d",j);
	    b->pwstr[i]=pwstring[j-1];
	  }
	  b->pwstr[5]=0;
	  putv(13);
	  b->waitpw=TRUE;
        }
      }
      else
	putpass(befbuf,0);

    } break;

    case v:
      dofile(befbuf,"rt",vtextfile);
      break;

    case e:
      dofile(befbuf,"at",etextfile);
      break;

    case r:
      dofile(befbuf,"rt",stextfile);
      break;

    case rp:
      dofile(befbuf,"rb",sbinfile);
      break;

    case ww:
      dofile(befbuf,"at",rtextfile);
      break;

    case wp:
      dofile(befbuf,"wb",rbinfile);
      break;

    case c:
    { if(get_lstate()<info_transfer)
      { doppunkt=0;
        te_connect(NULL,befbuf);
      }
      else
      { if(!remotefl)
	  line[wnd]--;
	putprompt(0);
	putf("CONNECT %s",get_concall());
      }
    } break;

    case x:
    { if(*befbuf)
      { char fromcall[10];
        int i=0;

	doppunkt=0;
        while(befbuf[0]>' ' && i<9)
        { fromcall[i]=befbuf[0];
          befbuf++;
          i++;
        }
        fromcall[i]=0;
        befbuf+=blkill(befbuf);
        te_connect(fromcall,befbuf);
      }
      else
      { if(!remotefl)
	  line[wnd]--;
	putprompt(0);
	putf("XCONNECT %s %s",get_mycall(),get_concall());
      }
    } break;

    case q:
    { if(befbuf[0])
	tnc_disconnect(4);
      else
      {
	stsend(wt->qtext);
	tnc_disconnect(2);    /* warten bis Besttigung oder Quittime */
      }
    } break;

    case d:
    { if(toupper(befbuf[0])=='A')
        tnc_disconnect(5);
      else
        tnc_disconnect(1);     /* sofort disconnecten  */
    } break;

    case name:
      if(befbuf[0]==0)
        strcpy(befbuf,get_partner());
      putf("Name (%s) = %s\r",befbuf,getname(befbuf));
      break;

    case cl:
    case xcl:
    { if(!(*befbuf))
      { if(bildport==0)
	  *(--befbuf)='3';
	else
	  *(--befbuf)='2';
      }
      if(*befbuf=='1')
      { wnd=txwin;
        set_color(txcolor,0);
	cls();
        befbuf++;
      }
      if(*befbuf=='2')
      { wnd=rxwin;
        set_color(rxcolor,0);
	cls();
        befbuf++;
      }
      if(*befbuf=='3')
      { wnd=monwin;
	set_color(monheader,0);
        cls();
      }
    } break;

    case sa:
    { i=maxcolor-1;
      if(sscanf(befbuf,"%d%x",&i,&j)>1)
      { putf(">>> war %02X\r",(wt->attr[colset+i]>>8));
        wt->attr[colset+i]=j<<8;
      }
      else
      { for(k=0;k<=i;k++)
	{ putprompt(0);
	  putf("SATTRIB %d %02X\r",k,(wt->attr[colset+k]>>8));
	}
      }
    }

    case st:
      stinput(befbuf);
      break;

    case list:
      stlist(befbuf);
      break;

    case catalog:
    case dir:
    { char *s;
      char mask[80];
      char *dirlist;
      int count=0;
      int i;
#define DIRLEN  40
#define MAXDIRS 200

      dirlist=(char *)malloc(DIRLEN*(MAXDIRS+1));
      if(dirlist)
      {
        wnd=rxwin;
        set_color(txcolor,0);
        if(remotefl && !b->pwok)
        { strcpy(mask,syspath("REMOTE\\"));
          if(befbuf[0]=='.') befbuf[0]=0;
          while(strstr(befbuf,"\\")) befbuf++;
          while(strstr(befbuf,"/"))  befbuf++;
          strcat(mask,befbuf);
        }
        else
          strcpy(mask,befbuf);
        modifymask(mask);
        putf(">>> Directory of %s\r",mask);
        s=dirline(mask,2);
        if(s)
        { while(s && count<MAXDIRS)
	  { strcpy(dirlist+count*DIRLEN,s);
	    count++;
            s=dirline(mask,3);
	  }
          qsort((void *)dirlist,count,DIRLEN,
                (int(*)(const void *,const void *))strcmp);
          for(i=0;i<(count/2);i++)
          {
            putf("%s      ",dirlist+DIRLEN*i);
            putf("%s\r"    ,dirlist+DIRLEN*(i+(count/2)));
          }
          if(count&1)
            putf("%*s%s\r",count==1?0:42,"",dirlist+DIRLEN*(count-1));

          putf(">>> %d File%s       %ld kBytes free.\r",
               count,count==1?"":"s",dfree(mask,0)/1024);
        }
        else
	  putf(">>> File not found.\r");
        wnd=(WND)curwin;
        free(dirlist);
      }
    } break;

    case cd:
    { chdir(befbuf);
      getcwd(befbuf,80);
      putf("%s\r",befbuf);
    } break;

    case dist:
    { putf(VNUMMER);
      putf(" did");
      putf("=%d\r",8400,0xaeaeaeaeL);
    } break;

    case rtt:
      if(strlen(befbuf)>6)
      {
        putf(">>> Response delay (both directions): %ld seconds\r",
	time(NULL)-atol(befbuf));
      }
      else
      { char *bef="e";
        if(befbuf[0])
          bef=befbuf;
        tnc_putf("//%s //RTT %ld\r",bef,time(NULL));
	tnc_flush();
      }
      break;

    case priv:
      if(b->privoffset<0)
        putf(">>> Cannot determine login time.\r");
      else
      { char privname[21];
        FILE *f;
        if(befbuf[0])
          sprintf(privname,"%0.19s",befbuf);
        else
        {
          strcpy(privname,get_partner());
          if(strchr(privname,'-'))
            strchr(privname,'-')[0]=0;
          strcat(privname,".PWD");
        }

        f=sysopen(privname,"rt");
        if(f)
        { fseek(f,b->privoffset,SEEK_SET);
          fread(privname,4,1,f);
          privname[4]=0;
          fclose(f);
          tnc_putf("PRIV %s\r",privname);
          tnc_flush();
          putf(">>> PRIV %s gesendet.\r",privname);
        }
        else
          putf(">>> %s nicht gefunden.\r",privname);
      }
      break;

  }
}

/*---------------------------------------------------------------------------*/

int rcmdtest(char *buf)
{ int i=1;
  char *partner=get_partner();

  if(isMailbox(partner))
    return NIX;
  if(strcmp(buf,"j")==0) return OK;
  if(!wt->remoteon) return NIX;
  if(b->ismailbox) return NIX;
  if(wt->rcmdstring[1]=='*') return OK;
  if((buf[0]>='0')&&(buf[0]<='9')) return OK;
  if((toupper(buf[0])=='E')&&(buf[1]==' ')) return OK;
  strcpy(cbuf+1,buf);
  cbuf[0]=' ';
  if(cbuf[1]<=' ') return NIX;
  strupr(cbuf);
  while(cbuf[i]>' ')i++;
  cbuf[i]=0;
  if(strstr(wt->rcmdstring,cbuf)) {
    return OK;
  }
  return NO;
}

/*---------------------------------------------------------------------------*/

void dologin(int ctextsend)
{ int i;
 // char partnercall[7];

  if(get_lstate()>=info_transfer && !get_outgoing() && ctextsend)
  {
    stsend(wt->ctext);
    char filename[22]="ANSWER\\";
    struct ffblk ff;
    if(findfirst(syspath("ANSWER"),&ff,FA_DIREC)!=0)
      filename[0]=0;
    strcpy(filename+strlen(filename),get_partner());
    if(strchr(filename,'-'))
      strchr(filename,'-')[0]=0;
    strcat(filename,".CTX");
    outfile(syspath(filename));
  } /*doodle.....*/
  if(ctextsend)
  { for(i=0;i<MAXRECON;i++)
      b->recon[i][0]=0;
  }
  b->ismailbox=0;
  /*
  readcall(get_partner(),partnercall);
  i=0;
  do
  { if(callwildcmp(partnercall,wt->boxcalls+i))
      b->ismailbox=1;
    i+=7;
  }
  while(!(wt->boxcalls[i-1]&1));
  */
  b->connlines=0;
  b->privoffset=(-1);
  if(ctextsend)
  { switch(b->filejob)
    { case rbinfile:
      case sbinfile:
      case stextfile:
      case rtext7plus:
           doclose();
           doopen();
           break;
    }
  }
}

/*---------------------------------------------------------------------------*/

char *cntchr(char *s,char c,unsigned num)
{ int i,j=0;
  for(i=0;i<strlen(s);i++)
  {
    if(s[i]==c)
      j++;
    if(j==num)
      return s+i+1;
  }
  return NULL;
}

/*---------------------------------------------------------------------------*/

// " go_7+"
//  012345
void checksave(char *buf)
{ char fname[71];
  int part;
  int parts;
  char *dot;

  //Deti 04/96
  if((buf[0]=='#')&& wt->p7psave&&!strncmp(buf,"#BIN#",4))
  {
    if( ((dot=cntchr(buf,'#',5))!=NULL)||((dot=cntchr(buf,'#',4))!=NULL))
    {
      char drive[_MAX_DRIVE],dir[_MAX_DIR],file[_MAX_FNAME],ext[_MAX_EXT];

      subst(dot,'/','\\');
      _splitpath(dot,drive,dir,file,ext);
      sprintf(fname,"%s\\%s%s",syspath("remote"),file,ext);
      mkdir(syspath("remote"));
      autobin=1;
      dofile(fname,"wb",rbinfile);
      autobin=0;
      if(b->file)
      { b->german=0;
        b->filelen=atol(buf+5);
        b->waitbin=0;
        tnc_putf("#OK#\r");
        tnc_flush();
      }
    }
  }
  else
  if(buf[0]==' ' && wt->p7psave)
  {
    if(strncmp(buf," go_7+",6)==0)
    { strcpy(fname,syspath("7PLUS\\"));
      mkdir(syspath("7plus"));
      if(sscanf(buf," go_7+. %d of %d %20s",
         &part,&parts,fname+strlen(fname))==3)
      { dot=strchr(fname,'.');
        if(!dot)
        {
          dot=fname+strlen(fname);
        }
        if(parts>1)
          sprintf(dot,".P%02X",part);
        else
          sprintf(dot,".7PL");
        dofile(fname,"wt",rtext7plus);
        if(b->file)
        { fprintf(b->file,"%s\n",buf);
          b->german=0;
        }
      }
    }
    else if(strncmp(buf," go_text",8)==0)
    { strcpy(fname,syspath("7PLUS\\"));
      mkdir(syspath("7plus"));
      if(sscanf(buf," go_text. %20s",fname+strlen(fname))==1)
      { dofile(fname,"at",rtext7plus);
        if(b->file)
        { fprintf(b->file,"%s\n",buf);
          b->german=0;
        }
      }
    }
    else if(strncmp(buf," go_info",8)==0)
    { strcpy(fname,syspath("7PLUS\\"));
      mkdir(syspath("7plus"));
      if(sscanf(buf," go_info. %20s",fname+strlen(fname))==1)
      { dofile(fname,"at",rtext7plus);
        if(b->file)
        { fprintf(b->file,"%s\n",buf);
          b->german=0;
        }
      }
    }
    else if(b->filejob==rtext7plus && strstr(buf," stop_")==buf)
    { doclose();
      doopen();
    }
  }
}

/*---------------------------------------------------------------------------*/

void loginline(char *date)
{ // 01.01.94 15:30
  // 01234567890123
  int day,hour,min;

  while(date[0] && !isdigit(date[0])) date++;
  if(b->privoffset>=0)
    return;
  if(date[0]==0)
    return;
  day=atoi(date);
  hour=atoi(date+9);
  min=atoi(date+12);

  b->privoffset=((min+day)%60)*27+hour;
}

/*---------------------------------------------------------------------------*/

void doodle(int soundnum)
{ int i;
  if(wt->cbell)
  { delay(2);
    switch(soundnum)
    { case 1:
      { for(i=0;i<3;i++)
	{ delay(2);
	  nosound();
	  sound(800);
	  delay(20);
	  sound(1100);
	  delay(15);
	  sound(1700);
	  delay(10);
	  nosound();
	}
      } break;
      case 2:
      { sound(2000);
	delay(50);
	nosound();
	delay(50);
	sound(2000);
	delay(50);
	nosound();
	delay(100);
      } break;
    }
  }
}

/*---------------------------------------------------------------------------*/

void process_message(void)
{ char msgbuf[80]="";
  int a,i=0;
  static char *msgptr[]=
  { "",
    "Connected to",
    "Disconnected from",
    "Failure with",
    "Frame Reject with",
    "Busy from",
    "Connect Request from",
  };

  while((a=tnc_get_msg())!=EOF)
  { if(a==13)
      break;
    msgbuf[i++]=a;
  }
  msgbuf[i]=0;
  if(i)
  {
    if(msgbuf[0]!=msg_connected)
      putf("\r>>>%7.7s%s%s\r",msgbuf+1,msgptr[msgbuf[0]],msgbuf+7);

    switch(msgbuf[0])
    {
      case msg_connected:
        char *s=getname(msgbuf+8);
        doodle(1);
        putf("\r>>>%7.7s%s%s   ",msgbuf+1,msgptr[msgbuf[0]],msgbuf+7);
        if(s[0])//Deti 04/96
          putf("(%s)",s);
        putv('\r');
      	dologin(1);
        b->logintime=time(NULL);
        break;

      case msg_disconnected:
        doodle(2);
        break;

        /*
           msg_failure,
           msg_frmr,
           msg_busy,
           msg_conrequest

         */

    }
  }
}

/*---------------------------------------------------------------------------*/

void remtest(char zeichen)
{
  if(zeichen==13)
  { char *remb=b->rembuf,*dp;

    remb[b->remindex]=0;
    b->connlines++;

    if((b->filejob!=rbinfile)||(stricmp(remb,"//wprg off")==0))
    { int recon=strstr(remb,"> Re")||strstr(remb,"* re");
      if(recon || b->connscharf)
      { dp=strstr(remb,"onnected to ");
        if(dp)
        { int i=0;
          char partner[11];

	  b->connscharf=FALSE;
	  dp+=12;
          remb=strstr(dp,":");
          if(remb)
            remb+=1;
          else
            remb=dp;

	  while((i<9)&&(remb[i]>='-'))
	  { partner[i]=remb[i];
	    partner[++i]=0;
	    b->connscharf=waitpoll();               // in STEXT.C
	  }
          strupr(partner);
          if(recon)
          { for(i=0;i<MAXRECON;i++)
            { if(strcmp(b->recon[i],partner)==0)
                recon=2;
            }
          }
          if(recon!=1)
          { for(i=0;i<MAXRECON;i++)
            { if(b->recon[i][0]==0)
              { strcpy(b->recon[i],get_partner());
                break;
              }
            }
            set_partner(partner);
	    dologin(0);
          }
        }
      }
      else if(b->waitpw)
      { if(strstr(remb,b->pwstr)) b->pwok=TRUE;
	b->waitpw=FALSE;
      }
      else if(b->pwscharf || b->connlines<5)
      { char *l=strstr(remb,"Login: ");
        if(l)
          loginline(l);
        l=strstr(remb,"> ");
        if(l>(remb+4) && strlen(l)>8 && (isdigit(l[2]) || isdigit(l[3])))
        { if(putpass(remb,0))
            b->pwscharf=0;
        }
        if(b->pwscharf)
          b->pwscharf--;
      }

      if((remb[0]=='/') && (remb[1]=='/'))
      { remotefl=1;
        int rok=rcmdtest(remb+2);
	if(rok==OK || b->pwok)
	  beftest(remb+2);
	else
	{ if(rok==NO) {
	    putf(">>> Remote-Commands:%s\r",wt->rcmdstring);
	  }
	}
	wnd=rxwin;
	set_color(rxcolor,0);
	remotefl=0;
	tnc_flush();
      }
      else
        checksave(remb);
    }
    else
    { if(get_lstate()==disconnected)
      { doclose();
        doopen();            // Default-File ffnen
      }
      if(b->waitbin)
      { if(strstr(remb,"#BIN#")==remb)
        {
          b->filelen=atol(remb+5);
          b->waitbin=0;
          tnc_putf("#OK#\r");
          tnc_flush();
        }
      }
    }
    b->remindex=0;
    remb[0]=0;
  }
  else if(zeichen=='>' && b->pwscharf &&
          strchr(b->rembuf,'(') && strstr(b->rembuf,") ") &&
          isdigit(b->rembuf[b->remindex-1]) &&
          b->remindex<18)
  {
    b->rembuf[b->remindex]=0;
    if(putpass(b->rembuf,1))
      b->pwscharf=0;
  }
  else if(b->remindex<79)
  {
    b->rembuf[b->remindex++]=zeichen;
  }
}

/*---------------------------------------------------------------------------*/
  
void makeline(int help,int shift)
{ int i,a;
  char befbuf[180];

  for(i=0;i<maxcol;i++)                         /* Zeile aus Videoram lesen */
  { a=*(ladr+i);
    if((a&0xff00)==catt)a=a&31;
    befbuf[i]=a&255;
  }
  i=maxcol-1;
  while(i && (befbuf[i-1]==' '))i--;          /* Ende der Eingabe suchen */
  befbuf[i]=0;

  if(help>0)
  { i=a=column[wnd];
    strupr(befbuf);
    while(i && isalnum(befbuf[i-1]))i--;
    while((a<79) && isalnum(befbuf[a]))a++;
    befbuf[a]=0;
    puthelp(befbuf+i);
  }
  else if(!getprompt(befbuf))
  { ctrlzeichen(13,1);
    if(shift==0)
      befbuf[i++]=13;
    befbuf[i]=0;
    i=0;
    if((strcmp(befbuf,"pw\r")==0)||
       (strcmp(befbuf,"sy\r")==0)||
       (strcmp(befbuf,"/sy\r")==0)||
       (strcmp(befbuf,"//j\r")==0))
      b->pwscharf=3;
    else
      b->pwscharf=FALSE;
    if(stristr(befbuf,"c ")==befbuf || stricmp(befbuf,"m\r")==0)
      b->connscharf=TRUE;
    else
      b->connscharf=FALSE;

    while(befbuf[i])
    {
      if(b->filejob!=etextfile)
      { if(b->german)
	  tnc_buffer(ibmansi(befbuf[i]));
	else
	  tnc_buffer(befbuf[i]);
	if((curwin==txwin)&&((wt->echo==1)||
	   ((b->lastchar=='>')&&(wt->echo==2)))&&(b->port))
	{ if(befbuf[i]==13)
	    b->lastchar=0;
	  switch(b->filejob)
          { case rtextfile:
            case rtext7plus:
            	 goto rausschreiben;
            default:
	         goto untenhinschreiben;
          }
	}
      }
      else
      { rausschreiben:
	if(befbuf[i]!=13)
	  fputc(befbuf[i],b->file);
	else
	  fputc(10,b->file);
	untenhinschreiben:
	if(curwin==txwin)
	{ wnd=rxwin;
	  set_color(txcolor,0);
	  putv(befbuf[i]);
	  wnd=(WND)curwin;
	}
	if(critical_error) doclose();
      }
      i++;
    }
    b->lastchar=0;
    if(help==0 && b->port==0)
      tnc_flush();
  }
  else
  { i=getprompt(befbuf);        /* alle Doppelpunkte entfernen */
    column[curwin]=i;
    doppunkt=TRUE;
    beftest(befbuf+i);
    set_color(txcolor,0);
    wnd=(WND)curwin;
    if(column[curwin])
      crlf();
    if((((*(ladr)&0xff)==' ')||getlprompt(ladr))&&doppunkt&&wt->command)
      putprompt(0);
  }
}

/*---------------------------------------------------------------------------*/

void screenedit(void)
{ unsigned a,i;
  char scancode,taste;
  bool shift=false;

  wnd=(WND)curwin;
  set_color(txcolor,0);

  if(taste())
  { a=bioskey(0);
    scancode=a/256;
    taste=a%256;

    // left or right shift key
    shift=((bioskey(2)&3) != 0);
  }
  else if(stbereit())
  { a=taste=next_st_char();
    if(taste==13)
      scancode=28;
    else
      scancode=0;
  }
  else
  { 
    return;
  }

  if(taste==255)
  { for(i=0;i<80;i++)
      (ladr)[i]=att|' ';
    column[wnd]=0;
  }
  else if((taste==10) && (scancode==28))                /* Control-Return */
  { ctrlzeichen(13,1);
    setzcurs(1);
    return;
  }
  else if((taste==8) && (scancode==14))                        /* Backspace */
    ctrlzeichen(8,1);
  else if(!taste && (scancode!=94)) /* Wenn Tastencode=0 dann Steuerzeichen */
  {
    ctrlzeichen(scancode,1,shift);               /* Steuerzeichen auswerten */
  }
  else if(a==0x4e2b)
    b->stop^=2;
  else if(a==0x4a2d)
    ctrlzeichen(67,1);
  else if(scancode==1 || (taste==9 && scancode==15))      /* ESC oder TAB */
  { char colsave=column[wnd];
    column[wnd]=0;
    if((i=getlprompt(ladr))>0)               /* ist ein Doppelpunkt da?   */
    { while(i)
      { delchar();
	i--;
	if(colsave)colsave--;
      }
    }
    else
      colsave+=putprompt(1);
    column[wnd]=colsave;
  }
  else if((column[wnd]==(wt->wordwrap-1)) && (taste!=13))
  { if(taste==' ')
      makeline((-1),0);
    else
    { i=wt->wordwrap-2;
      if(line[wnd]==bottom[wnd])
      { scroll(0);
        if(line[wnd]) line[wnd]--;
      }
      while(' '!=(*(ladr+i)&255) && i)i--;
      a=0;
      i++;

      while(i<(wt->wordwrap)-1)
      { *(ladr+a+maxcol)=*(ladr+i);
        *(ladr+i)=att|' ';
        i++;
        a++;
      }
      makeline(-1,0);
      column[wnd]=a;
      if(taste!=13)putvo(taste);
    }
  }
  else if(taste==13 && scancode==28 && shift)    
    /* SHIFT Return */
    makeline(0,1);
  else if((taste==13 && scancode==28)||(scancode==94))    
    /* Nur Return, nicht CTRL-M */
    makeline(scancode==94,0);
  else
  { inschar(0);
    putvo(taste);
  }
  setzcurs(1);
  return;
}

/*---------------------------------------------------------------------------*/

void statmove(int ctrlrauf,int ctrlrunter,unsigned *pos)
{ int y=mauszeile();
  while(mausknopf())
  { mausein();
    if(mauszeile()<y)
    { mausaus();
      ctrlzeichen(ctrlrauf,0);
    }
    if(mauszeile()>y)
    { mausaus();
      ctrlzeichen(ctrlrunter,0);
    }
    y=*pos;
  }
}

/*---------------------------------------------------------------------------*/

void mauscursor(void)
{ int pos=-1;
  while(mausknopf())
  { mausein();
    if(pos!=mauszeile())
    { pos=mauszeile();
      mausaus();
      if((pos!=wt->txwinlen) && (pos!=wt->divline))
      { if(pos<wt->txwinlen)        ctrlzeichen(120,0);
	else if(pos<wt->divline)    ctrlzeichen(121,0);
	else                       ctrlzeichen(122,0);
	line[curwin]=pos;
      }
    }
    column[curwin]=mausspalte();
  }
}

/*---------------------------------------------------------------------------*/

void testmaus(void)
{ int pos;
  int wndsave=wnd;
  wnd=(WND)curwin;
  if(mausistda())
  { if(mausknopf())
    { screenon();
      setzcurs(-1);
      mausaus();
      pos=mauszeile();
      if(pos==wt->txwinlen)
	statmove(119,117,&wt->txwinlen);
      else if(pos==wt->divline)
	statmove(132,118,&wt->divline);
      else
	mauscursor();
      setzcurs(1);
    }
    mausein();
    if(mausrechts())
    { char buf[10];
      int x,i=0;
      video *b;

      screenon();
      while(mausrechts());
      x=mausspalte();
      b=vram+maxcol*mauszeile();
      mausaus();

      while(x && isalnum(b[x-1]&255))x--;
      while(i<10 && isalnum(b[x]&255))
	buf[i++]=b[x++]&255;
      buf[i]=0;
      strupr(buf);
      puthelp(buf);
      setzcurs(1);
    }
  }
  wnd=(WND)wndsave;
}

/*---------------------------------------------------------------------------*/

int putrxdata(int port)
{ int ch=EOF;
  int gekommen=0;
  int number=0;
  wnd=rxwin;

  if(get_lstate()==disconnected)
  { b->german=wt->germanon;
    b->pwok=FALSE;
  }

  if(b->port==0)
    return 0;
  if(b->filejob>=etextfile)
    return 0;

  while((ch=tnc_get())>EOF)
  { if(gekommen==0)
    { gekommen=1;
      mausaus();
    }
    if(b->filejob==rbinfile)
    { if(b->waitbin==0)
      { if(fputc(ch,b->file)==EOF) 
          doclose();
        crc(ch,&b->crcword);
        if(critical_error) doclose();
        if(wt->autobin && !(--b->filelen))
        { //putv(ch); //Deti 04/96
          doclose();
	  doopen();            // Default-File ffnen
	  putf("\rBIN-RX OK #%u\r",b->crcword);
          tnc_putf("BIN-RX OK #%u\r",b->crcword);
          goto nixoutput;
        }
      }
    }
    else
    { if((ch==7)&&(b->lastchar!=7))     // nur ein CTRL-G auswerten!
      { doodle(1);
      }
      else if((ch==0x17)&&(b->lastchar==' '))
      { doodle(2);
      }
    }
    switch(b->filejob)
    { case rtextfile:
      case rtext7plus:
        if(ch==13)
	  fputc(10,b->file);
        else
          fputc(ch,b->file);
        if(critical_error) doclose();
        if(b->filejob==rtext7plus)
          goto nixoutput;
        break;
        case rbinfile: //Deti 04/96
          goto nixoutput;
    }
    putv(ansiibm(ch));
    nixoutput:
    remtest(ch);
    b->lastchar=ch;
    if(taste() || (number++>500))
      break;
  }
  if(gekommen && wt->knax)
  { delay(1);
    nosound();
    sound(50);                           /* knax */
    delay(2);
    nosound();
  }
  return gekommen;
}

void puttxdata(void)
{ int i;
  int ch=EOF;
  int job=b->filejob;

  if(tnc_putfree())
  { if((job==sbinfile)||(job==vtextfile)||(job==stextfile))
    { mausaus();
      if(job==sbinfile)
      { for(i=0;i<256;i++)
        { if(EOF!=(ch=fgetc(b->file)))
	  { tnc_put(ch);
	    crc(ch,&b->crcword);
	  }
	  else
	  { if(wt->autobin)
	    { remotefl=1;
	      putf("BIN-TX OK #%u\r",b->crcword);
	      remotefl=0;
	    }
	    goto filende;
	  }
	  if(critical_error) goto filende;
        }
      }
      if(job==stextfile)
      { for(i=0;i<256;i++)
        { if(EOF!=(ch=fgetc(b->file)))
          { if(ch!=10)
	    { if(ch!=13)
	      { putv(ch);
	        if(b->german)
		  tnc_put(ibmansi(ch));
	        else
		  tnc_put(ch);
	      }
	    }
	    else
	    { putv(13);
	      tnc_put(13);
	    }
	  }
	  else
	    goto filende;
	  if(critical_error) goto filende;
        }
      }
      if(job==vtextfile)
      { for(i=0;i<256;i++)
        { if(EOF!=(ch=fgetc(b->file)))
          { if(critical_error) goto filende;
            if(ch!=10)
            { if(ch!=13)
                putv(ch);
            }
            else
	      putv(13);
          }
          else
	  { filende:
	    tnc_flush();
            doclose();
	    doopen();            // Default-File ffnen
	    break;
	  }
        }
      }
    }
    else while(b->sendbuffer && tnc_putfree())
    { if(b->send_in == b->send_out)
      { free(b->sendbuffer);
        b->sendbuffer=0;
        tnc_flush();
        b->send_in=0;
        b->send_out=0;
      }
      else
        tnc_put(b->sendbuffer[b->send_out++]);
    }
  }
}


void putmonitor(void)
{
  int ch;
  int psave=bildport;
  static video monatt=monheader+2*maxcolor;

  b->german=wt->germanon;

  //if(1 )                   /* falls Sperre in L2 gesetzt */
  /************************************************************/
  { bildport=0;
    wnd=monwin;
    att=monatt;
    int count=0;

    while((ch=tnc_get())>EOF && count<1000)
    { count++;
      mausaus();
      if(ch>=0xfd)
      { if(ch>=0xfe)
	  set_color(moninfo,0);
	else
	{ set_color(monheader,0);
	  crlf();
	  if(b->file)
	  { fputc(10,b->file);
	    if(critical_error) doclose();
	  }
	  if(taste()) goto monexit;
	}
      }
      else
      { 
        putv(ansiibm(ch));
	if(b->file)
	{ if(ch==13)
	    fputc(10,b->file);
	  else
	    if(ch>31)
	      fputc(ch,b->file);
	  if(critical_error) doclose();
	}
      }
      if(taste()) break;
    }
    monexit:
    bildport=psave;
    monatt=att;
  }
}

/*---------------------------------------------------------------------------*/

void scanports(void)
{ int port;
  static int nomonitor=0;

  set_context(bildport);

  b->rbufcolumn=column[rxwin];
  b->rbufline=line[rxwin];
  set_context(0);

  if(!b->stop && !nomonitor)
    putmonitor();

  nomonitor=0;

  for(port=1;((port<maxports)&&(!taste()));port++)
  {
    set_context(port);

    if(!b->stop)
    { wnd=rxwin;
      set_color(rxcolor,0);
      column[rxwin]=b->rbufcolumn;
      line[rxwin]=b->rbufline;
      process_message();
      nomonitor+=putrxdata(port);
      set_color(txcolor,0);
      puttxdata();
      b->rbufcolumn=column[rxwin];
      b->rbufline=line[rxwin];
    }
  }
  set_context(bildport);
  column[rxwin]=b->rbufcolumn;
  line[rxwin]=b->rbufline;
}

/*---------------------------------------------------------------------------*/

void portfclose(void)
{ int i;
  taskvar_t *bsave=b;

  for(i=0;i<maxports;i++)
  { set_context(i);

    if(b->filejob!=nofile)
    { b->filepos=ftell(b->file);
      fclose(b->file);
    }
  }
  b=bsave;
}

/*---------------------------------------------------------------------------*/

void portfopen(void)
{ int i;
  for(i=0;i<maxports;i++)
  { set_context(i);
    doopen();
  }
  set_context(bildport);
}

/*---------------------------------------------------------------------------*/

int break_handler(void)
{ 
  return 2;
}

/*---------------------------------------------------------------------------*/

static int chk_close(void)
{
  /* Close-Faehigkeit anmelden, reicht eigentlich einmal beim Start */
  _DX = 0x0001;   /* enable/disable close */
  _AX = 0x168F;
  geninterrupt(0x2F);	/* Returnwert brauchen wir nicht */

  /* Jetzt (zyklisch) gucken ob Close gewuenscht */
  _DX = 0x0100;   /* Query close */
  _AX = 0x168F;
  geninterrupt(0x2F);	/* Returnwert brauchen wir nicht */
  if (_AX == 0)
  {
    _DX = 0x0200;   /* acknowledge close */
    _AX = 0x168F;
    geninterrupt(0x2F);	/* Returnwert brauchen wir nicht */

    /* Hier machen und tun was zugemacht werden muss */
    return 1; /* So oder anders */
  }
  return 0;
}

/*---------------------------------------------------------------------------*/

int main(int argc,char *argv[])
{ int bp=1;
  int i;
  int clearscreen=0;

  while(argc>1)
  { argc--;
    if(argv[argc][0]=='-' || argv[argc][0]=='/')
    {
      switch(argv[argc][1]&0x5f)
      { case 'C':
          clearscreen=1;
          break;
        case 'N':
          nol1par=1;
          break;
        case 'M':
          miniram=1;
          break;
        case 'R':
          freekb=atol(argv[argc]+2)<<10;
          if(freekb<10000)
            freekb=10000;
          break;
        default:
	  puts(" BayCom Packet-Radio Terminal V"VNUMMER
               "  (C) "YEAR" Florian Radlherr, DL8MBT et al\n"
               "FlexNet interface version for free amateur radio usage ONLY\n"
               "\nBCT [<call>] [/N] [/C] [/M] [/R<kbytes>]\n\n"
               "  /N         Do not load l1-parameters to AX.25-driver\n"
	       "  /C         Clear terminal screen\n"
	       "  /M         Reserve maximum of memory for DOS shell\n"
	       "  /R<kBytes> Reserve <kBytes> of memory for DOS shell "
               "(Default: 90kBytes)");
	  exit(0);
      }
    }
    else
    { strcpy(mycall[mynum],argv[argc]);
      strupr(mycall[mynum]);
      mycall[++mynum][0]=0;
    }
  }

  switch(maxports=tnc_init(MAXTERMPORTS-1))
  {
    case -1:
      puts("AX.25-Driver not found. Please start FlexNet/L2 before BCT!");
      return 1;

    case -2:
      puts("Type EXIT to return to BayCom terminal...");
      return 1;

    default:
      int ret;
      if(check_node())
        nol1par=1;
      harderr(crit_handler);
      setcbrk(0);
      ctrlbrk(break_handler);
      fixpath();
      for(i=0;i<MAXTERMPORTS;i++)
      { memset(bfeld+i,0,sizeof(taskvar_t));
        bfeld[i].port=i;
        bfeld[i].filejob=nofile;
      }
      //Deti 04/96
      if((ret=loadpar())>0)
      { portfopen();
        initvideo();
        uninit=0;
        bildport=b->port;
        portset(bildport);
        if(!clearscreen)
	  bp=plattebild();
        unlink(syspath(VIDNAME));
        if(bp==-1)
        { portset(1);
	  wnd=txwin;
	  einmeldung(0);
	  putprompt(1);
        }
        else
	  portset(bp);
        wnd=(WND)curwin;
        setzcurs(1);
        if(wt->mouseon)
        {
          mausinit(maxline,79);
        }
        do
        {
	  screenon();
	  while(!taste() && !stbereit())
	  { screenoff();
	    testmaus();
	    //if(!wt->exitlog)logupdate();
	    statst(0);
	    scanports();
            _AX=_BX=_CX=0;
            geninterrupt(0x28);
	    if(chk_close() || prgende)
            {/*
             int i,conn=0;
              for(i=1;i<maxports;i++)
              {
                set_tnc_context(i);
                if(get_lstate()!=disconnected)
                  conn++;
              }
              set_tnc_context(b->port);
              if(conn==0)
               */ goto schlussmachen;
            }
	  }
	  mausaus();
	  screenon();
	  screenedit();
        }
        while(1); //(!prgende);
        schlussmachen:
        mausaus();
        //logupdate();
        bildplatte();
        portfclose();
        savepar();
      }
      else
      {
        unlink(syspath(PARNAME));
        //Deti 04/96
        switch(ret) {
          case 0:  puts(
            "Parameter file '"INITNAME"' not found.\n\nUsage: BCT <Callsign>");
            break;
          case -1: puts(
            "File '"INITNAME"' is locked. You can run BCT only once.");
            break;
        }
        return 1;
      }
      break;
  }
  return 0;
}
