/***************************************************************

  BayCom(R)           Packet-Radio fuer IBM PC

  BayCom-Terminal


  --------
  BCT-Help
  --------

  Copyright (C) 1999 Flori Radlherr, DL8MBT, flori@baycom.org
      
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ***************************************************************/

#include "bct.h"

char helpstack[10][12];    // merkt Help-Begriffe
int helpx[10];             // merkt Cursorposition
int helpy[10];             // merkt Cursorposition
int helppage[10];          // merkt Seitennummer im Text
int helpsp=0;              // Index zu letztem aktiven Help



// *******************************************************************
//   winfile  zeigt ein Help-Fenster an
//            Uebergabe:
//               - File, in dem die Texte stehen (richtige Position)
//               - Suchbegriff
// *******************************************************************
void winfile(FILE *f,char *name,char *befbuf,int *curx,int *cury,int *prepage)
{ static char *menustr=
#if ENGLISCH
  "^Help^  ^Index^  ^prev^      Move select bar with cursor keys, ESC for ^end^ ";
#else
  "^Help^  ^Index^  ^zurck^      Bewegung mit den Cursortasten, ^Ende^ mit ESC ";
#endif

  wind wn;                                   // Fenster-Handle
  char string[86];                           // eine Zeile
  int att=wt->attr[colset+helpcolor];         // normales Attribut
  int atthi=wt->attr[colset+helphilight];     // hilight-Attribut
  int attselect=wt->attr[colset+helpselect];  // Cursor-Attribut
  int page=0,newpage=0;
  int lastpage=1;              // Flag fr letzte Seite pro Text
  long pageseek[10];           // merkt die Seitenanfnge im File

  vseg=FP_SEG(vram);           // Video-Segment setzen
  wn=wopen(4,2,71,20,NULL);    // Fenster vorbereiten
  cset(wn,*curx,*cury);        // Cursor positionieren
  do
  { int line=0;
    newpage=1;
    pageseek[page]=ftell(f);
    while((line<18)&&fgets(string,84,f)&&(string[0]!='\\'))
    { string[strlen(string)-1]=0;
      whelp(wn,line,att,atthi,string);
      line++;
    }
    lastpage=(string[0]=='\\');
    while(line<18)
      wstr(wn,line++,att,"");
    whelp(wn,line,att,atthi,menustr);
    wframe(wn,att,name);
    if(page)              ws(60,line+4,att,"pg.up");
    if(!lastpage)         ws(68,line+4,att+0x8000,"pg.dwn");
    if(page || !lastpage) wc(66,line+4,att,page+'1');

    if(*prepage > page)
      befbuf[0]='+';
    else
    { menuselect(wn,atthi,attselect,befbuf);
      *prepage=0;
    }
    if(befbuf[0]=='+')
    { if((!lastpage)&&(page<9))
        page++;
      else
        fseek(f,pageseek[page],SEEK_SET);
    }
    else if(befbuf[0]=='-')
    { if(page)
        page--;
      fseek(f,pageseek[page],SEEK_SET);
    }
    else
      newpage=0;
  }
  while(newpage);
  *prepage=page;
  *curx=xpos(wn);
  *cury=ypos(wn);
  wclose(wn);
}

void puthelp(char *befehl)
{ FILE *helpfile;
  char string[82];
  long seekpos=0;
  char *wort=
#if ENGLISCH
   "Help for ***************";
#else
   "Hilfe zu ***************";
#endif
  char befbuf[12];
  int newhelp=1;

  setlinlen(maxcol);
  if(!befehl)
  { if(!helpsp) helpsp=9; else helpsp--;
    strcpy(befbuf,helpstack[helpsp]);
    newhelp=0;
  }
  else
  { if(strlen(befehl)>11)
      befehl[11]=0;
    strcpy(befbuf,befehl);
  }

  if(strlen(befbuf)==0)
    strcpy(befbuf,"HELP");

  helpfile=sysopen(TERMHELPNAME,"rt");
  setvbuf(helpfile,NULL,_IOFBF,4096);

  if(helpfile && !remotefl)
  { static char *back=
#if ENGLISCH
     "PREV";
#else
     "ZURCK";
#endif
    screensave();
    setzcurs(-1);

    while(*befbuf)
    { strupr(befbuf);
      if((strstr(befbuf,back)==befbuf) || (befbuf[0]=='#'))
      { if(!helpsp) helpsp=9; else helpsp--;
        if(!helpsp) helpsp=9; else helpsp--;
        strcpy(befbuf,helpstack[helpsp]);
        newhelp=0;
      }
      fseek(helpfile,0,SEEK_SET);
      while(fgets(string,80,helpfile)&&(string[0]>='0')&&(string[0]<='Z'))
      { if(strstr(string,befbuf)==string)
	{ sscanf(string,"%s%lu",wort+9,&seekpos);
	  goto gefunden;
	}
      }
      fseek(helpfile,0,SEEK_SET);
      while(fgets(string,80,helpfile)&&(string[0]>='0')&&(string[0]<='Z'))
      { if(strstr(string,befbuf)!=NULL)
	{ sscanf(string,"%s%lu",wort+9,&seekpos);
          goto gefunden;
        }
      }
      goto nix;

      gefunden:
      fseek(helpfile,seekpos,SEEK_SET);
      strcpy(helpstack[helpsp],befbuf);
      if(newhelp)
      { befbuf[0]=0;
        helppage[helpsp]=0;
      }
      winfile(helpfile,wort,befbuf,&helpx[helpsp],&helpy[helpsp],&helppage[helpsp]);
      helpsp=((helpsp+1)%10);
      helpstack[helpsp][0]=0;
      helppage[helpsp]=0;
      newhelp=1;
    }
    nix:
    screenrestore();
  }
  if(helpfile)fclose(helpfile);
}


