/***************************************************************

  BayCom(R)           Packet-Radio fuer IBM PC

  BayCom-Terminal


  ---------------------------------------------------
  Definitions / Declarations for whole BAYCOM-Project
  ---------------------------------------------------

  Copyright (C) 1999 Flori Radlherr, DL8MBT, flori@baycom.org
      
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ***************************************************************/


#include "bct.h"
#include "l2host.h"
#undef SABM
#undef DISC
#undef FRMR
#undef UI
#undef UA
#undef DM
#undef RR
#undef REJ
#undef RNR
#include "flexappl.h"

/**************************** Interface *******************************/

#define biosminuten ((unsigned)(*((long far *)MK_FP(0x40,0x6c))/1092))

static unsigned streams  = 0;
static stream_t far *stream=NULL;
static stream_t far *stream_arr=NULL;
static unsigned l2found=0;
static unsigned selected_stream=0;
static int flx_ver=0;

/*---------------------------------------------------------------------------*/

typedef struct boxqso_t
{ unsigned tx_fbuf;
  unsigned rx_index;
  const INFO far *rx;
  char path[80];
  char message[80];
  char mycall[12];
  unsigned msg_index;
  int last_lstate;
} boxqso_t;

/*---------------------------------------------------------------------------*/

static boxqso_t qso[10];
static boxqso_t *q=NULL;
static TRACE tr;


static char *doszeit(unsigned minuten)
{ static char zeitstr[10];
  sprintf(zeitstr," %02u:%02u ",minuten/60,minuten%60);
  return zeitstr;
}

/*---------------------------------------------------------------------------*/

int check_node(void)
{
  return flx_ver-1;
}

/*---------------------------------------------------------------------------*/

static int get_mondata(void)
{ int   c='\r',i;
  char  s[80];
  static const FRAME *fr;

  static int  on=0;
  static char output[400]={0};
  static int  outptr=0;
  static int  maxoutptr=0;
  int nullen=1;
  if(tr.ch_mask&0xfc00)
    nullen=2;

  if(l2found)
  {
    if(outptr==maxoutptr && tr.trxfilter)
    {
      maxoutptr=outptr=0;
      output[0]=0;

      if(!on || l2_chk_monitor()==0)
      {
        on=l2_set_monitor(&tr);
      }

      if(on)
      {
        fr=l2_get_monitor();
        if(fr)
        {
          strcall(s,fr->source);
          sprintf(output,"\xfd%c%0*d%c%02d%s%s",fr->tx?'T':'R',
                  nullen,fr->kanal,(fr->axv2==2)?'*':':',fr->txdelay,
                  doszeit(biosminuten),s);
          for(i=0;i<fr->digis;i++)
          { strcall(s,fr->digi[i]);
            sprintf(output+strlen(output),"/%s",s);
            if(i<fr->nextdigi) strcat(output,"*");
          }
          strcall(s,fr->dest);
          sprintf(output+strlen(output),">%s>",s);
          switch(fr->typ)
          { case I:    sprintf(output+strlen(output),"I%d%d",fr->ns,fr->nr);
                       break;
            case RR:   sprintf(output+strlen(output),"RR%d",fr->nr);   break;
            case RNR:  sprintf(output+strlen(output),"RNR%d",fr->nr);  break;
            case REJ:  sprintf(output+strlen(output),"REJ%d",fr->nr);  break;
            case SABM: strcat(output,"SABM"); break;
            case DISC: strcat(output,"DISC"); break;
            case DM:   strcat(output,"DM");   break;
            case UA:   strcat(output,"UA");   break;
            case FRMR: strcat(output,"FRMR"); break;
            case UI:   strcat(output,"UI");   break;
            default:   strcat(output,"??");
          }
          if(fr->cmd)
            strcat(output,fr->pf?",P":",C");
          else
            strcat(output,fr->pf?",F":",R");
          if(fr->dama)
            strcat(output,",DAMA");
          outptr=strlen(output);
          if(fr->typ==I || fr->typ==UI)
          { sprintf(output+strlen(output),",%02X:\xfe",fr->pid);
            outptr=strlen(output);
            i=0;

            if((fr->pid==0xcc)||(fr->pid==0xcd))
            { i=40;
              strcat(output+outptr," <TCP/IP>");
              outptr=strlen(output);
              c=13;
            }
            else if(fr->textlen>20)
            { int binfl=0,j;
              for(j=0;j<fr->textlen;j++)
	      { char cc=fr->text[j];
                if((cc>127)||(cc<' '&&cc!=13))
                  binfl++;
              }
              if(binfl>(fr->textlen/4))
              { sprintf(output+outptr,"\r<BIN %d Bytes>",fr->textlen);
	        c=13;
                i=fr->textlen;
                outptr=strlen(output);
              }
            }
            while(i<fr->textlen)
            { if((c!=fr->text[i]) && (c<0xfd))
	        output[outptr++]=c;
              else if((c!=13) && (c<0xfd))
	        output[outptr++]=c;
              c=fr->text[i++];
            }
            if(c!=13) output[outptr++]=c;
          }
          output[outptr++]=0xff;
          output[outptr]=0;
          maxoutptr=outptr;
          outptr=0;
          l2_ack_monitor();
          fr=NULL;
        }
      }
    }
    if(outptr<maxoutptr)
      return output[outptr++];
  }
  else
  { c="\xfd*** AX.25-interface not found\xfd"[outptr];
    if(c)
    { outptr++;
      return c;
    }
  }
  return EOF;
}

/*---------------------------------------------------------------------------*/

static int get_tncchar(void)
{
  if(l2found && stream->number && stream->outgoing!=2)
  { char c;

    if(q->rx==NULL || q->rx_index==q->rx->len)
    { q->rx=l2_get_i(stream->number);
      q->rx_index=0;
    }

    if(q->rx)
    { c=q->rx->text[q->rx_index++];
      if(q->rx_index==q->rx->len)
      { l2_i_ack(stream->number);
        q->rx=NULL;
      }
      return c;
    }
  }
  return EOF;
}

/*---------------------------------------------------------------------------*/

static void linkmsg(linkmsg_t message)
{
  if(q && message>msg_nomessage && q->message[0]==0)
  { if(q->path[0]==0)
      strcpy(q->path,stream->partner);
    if(message!=msg_disconnected)
      stream->logintime=biosminuten;
    else
      stream->outgoing=0;
    sprintf(q->message,"%c%s%s\r",(int)message,doszeit(biosminuten),q->path);
  }
}

/*---------------------------------------------------------------------------*/

static void get_connect(void)
{ int qsonum=0;
  int i;
  int str;
  int old_stream=selected_stream;
  int myindex=0;

  for(myindex=0;wt->mycall[myindex][0];myindex++)
  {
    qsonum=l2_get_sabm(wt->mycall[myindex]);
    if(qsonum)
    {
      str=0;
      for(i=1;i<streams;i++)
      { if(stream_arr[i].number==qsonum)
        { l2_sabmresp(qsonum);
          return;
        }
      }
      for(i=1;i<streams;i++)
      { if(stream_arr[i].number==0)
        { str=i;
          break;
        }
      }
      if(str)
      { f_set_stream(str);
        stream->number=qsonum;
        const FRAME far *fr=l2_get_f(qsonum);
        strcall(q->path,fr->dest);
        strcall(stream->partner,fr->dest);
        stream->channel=fr->kanal;
        stream->outgoing=0;
        for(i=0;i<fr->digis;i++)
        { strcat(q->path," ");
          strcall(q->path+strlen(q->path),fr->digi[i]);
        }
        l2_sabmresp(qsonum);
        strcpy(q->mycall,wt->mycall[myindex]);
        f_set_stream(old_stream);
      }
      else
        l2_sabm_dm(qsonum);
    }
  }
}

/*---------------------------------------------------------------------------*/

/* service interface functions */
void f_tnc_flush(void)
{ if(l2found)
  { l2_pack(stream->number);
    q->tx_fbuf=0;
  }
}

/*---------------------------------------------------------------------------*/
  
void f_tnc_put(char a)
{ if(l2found)
  { if(selected_stream==0)
    { static char ui_info[80];
      static int ui_index=0;

      ui_info[ui_index]=a;
      if(ui_index<79)
        ui_index++;
      if(a==13)
      { l2_send_ui(q->mycall,q->path,0xf0,1,ui_index,ui_info);
        ui_index=0;
      }
    }
    else
    { if(stream->number)
      { if(q->tx_fbuf || f_tnc_putfree())
        { l2_send_char(stream->number,a);
          q->tx_fbuf--;
        }
      }
    }
  }
}

/*---------------------------------------------------------------------------*/
  
int f_tnc_putfree(void)
{ if(l2found && stream->number)
  { if(q->tx_fbuf==512 || l2_ialloc(stream->number,512))
    { q->tx_fbuf=512;
      return 255;
    }
    else
    { q->tx_fbuf=0;
      return 0;
    }
  }
  else
    return 255;
}

/*---------------------------------------------------------------------------*/
  
int f_tnc_get(void)
{ if(selected_stream==0)
    return get_mondata();
  else
    return get_tncchar();
}

/*---------------------------------------------------------------------------*/

int f_tnc_get_msg(void)
{
  if(l2found && q)
  { if(q->message[q->msg_index])
      return q->message[q->msg_index++];
    else
    { q->msg_index=0;
      q->message[0]=0;
    }
  }
  return EOF;
}

/*---------------------------------------------------------------------------*/

void f_tnc_connect(char *mycall,char *call)
{ int i=0;
  int qsonum;
  char tmp_mycall[12];
  char tmp_mycall2[12];
  int count=0;

  if(!mycall) mycall=wt->mycall[0];

  strupr(call);
  strupr(mycall);
  strcpy(tmp_mycall,mycall);

  if(!l2found)
    return;

  if(stream->number)
    l2_kill_qso(stream->number);

  while((qsonum=l2_check_path(tmp_mycall,call))!=0)
  { char *str=strchr(tmp_mycall,'-');
    if(count++ > 15)
      return;
    if(l2_state(qsonum)<2)
    { l2_kill_qso(qsonum);
      break;
    }

    if(str)
    { int ssid=atoi(str+1);
      str[0]=0;
      if(ssid==15) ssid=0;
      sprintf(tmp_mycall2,"%s-%d",tmp_mycall,ssid+1);
    }
    else
      sprintf(tmp_mycall2,"%s-1",tmp_mycall);
    strcpy(tmp_mycall,tmp_mycall2);
  }

  strcpy(q->mycall,tmp_mycall);
  if(selected_stream)
  { stream->number=l2_connect(tmp_mycall,call);
    stream->outgoing=2;

    const FRAME far *fr=l2_get_f(stream->number);
    strcall(q->path,fr->dest);
    q->tx_fbuf=0;
    strcall(stream->partner,fr->dest);
    stream->channel=fr->kanal;
    for(i=0;i<fr->digis;i++)
    { strcat(q->path," ");
      strcall(q->path+strlen(q->path),fr->digi[i]);
    }
  }
  else
    strcpy(q->path,call);
  i=0;
  while(q->path[i]>' ')
    stream->partner[i]=q->path[i++];
  stream->partner[i]=0;
}

/*---------------------------------------------------------------------------*/

void f_tnc_disconnect(int mode)
{ int i;

  if(l2found)
  { switch(mode)
    { case 0: l2_kill_qso(stream->number);
              break;
      case 1: if(get_lstate()==disc_request)
                l2_kill_qso(stream->number);
              else
                l2_cancel_qso(stream->number);
              break;
      case 2: l2_stop_qso(stream->number);
              break;
      case 5: for(i=1;i<streams;i++)
              { if(stream_arr[i].number)
                  l2_cancel_qso(stream_arr[i].number);
              }
              break;
    }
  }
}

/*---------------------------------------------------------------------------*/

void f_tnc_exit(void)
{ ax_exit();
}

/*---------------------------------------------------------------------------*/

int f_tnc_init(int maxstreams)
{
  if((flx_ver=ax_init())!=0)
  {
    atexit(f_tnc_exit);
    l2found=1;
  }
  stream_arr=(stream_t *)malloc(maxstreams*sizeof(stream_t));
  stream  = &stream_arr[0];
  streams=maxstreams-1;

  memset(stream_arr,0,maxstreams*sizeof(stream_t));

  memset(&tr,0,sizeof(TRACE));
  tr.ch_mask=0xffff;
  tr.trxfilter=3;

  return streams;
}

/* management functions, GET-operation */


/*---------------------------------------------------------------------------*/

char far *f_get_partner(void)
{
  return stream->partner;
}

/*---------------------------------------------------------------------------*/

lstate_t f_get_lstate(void)
{
  if(l2found)
  {
    get_connect();
    int tmp=l2_state(stream->number)&7;
    int stat=tmp;
    linkmsg_t msg;

    l2_bef(18,stream->number);
    if(tmp>0)
      tmp--;

    if(tmp==0)
    { stream->number=0;
      stream->outgoing=0;
      q->tx_fbuf=0;
    }

    if(tmp>(int)info_transfer)
      tmp=(int)info_transfer;

    stream->lstate=(lstate_t)tmp;

    if(q->last_lstate!=tmp)
    {

      switch(stream->lstate)
      {
        case disconnected:  if((lstate_t)q->last_lstate==link_setup)
                            { if(stat==0)
                                msg=msg_failure;
                              else
                                msg=msg_busy;
                            }
                            else
                              msg=msg_disconnected;
                            break;
        case info_transfer: msg=msg_connected;
                            if(stream->outgoing==2)
                              stream->outgoing=1;
                            if((lstate_t)q->last_lstate==link_setup)
                              stream->outgoing=1;
                            break;
        default:            msg=msg_nomessage;
      }

      q->last_lstate=tmp;
      /*
      typedef enum linkmsg_t
      { msg_nomessage,
        msg_connected,
        msg_disconnected,
        msg_failure,
        msg_frmr,
        msg_busy,
        msg_conrequest
      } linkmsg_t;
      */
      linkmsg(msg);
    }

    return stream->lstate;
  }
  else
    return disconnected;
}

/*---------------------------------------------------------------------------*/

char *f_get_mycall(void)
{ static char mybuf[11];
  if(l2found)
  {
    if(stream->number)
      strcpy(mybuf,q->mycall);
    else
      strcpy(mybuf,wt->mycall[0]);
  }
  else
    strcpy(mybuf,"DUMMY");
  return mybuf;
}

/*---------------------------------------------------------------------------*/

int f_get_outstanding(void)
{
  if(l2found)
    return l2_unack(stream->number);
  else
    return 0;
}

/*---------------------------------------------------------------------------*/

int f_get_retries(void)
{
  if(l2found)
    return l2_tries(stream->number);
  else
    return 0;
}

/*---------------------------------------------------------------------------*/
  
int f_get_l1state(void)
{ if(l2found)
    return ch_state(get_channel());
  else
    return 0;
}

/*---------------------------------------------------------------------------*/

int f_get_channel(void)
{
  return stream->channel;
}

/*---------------------------------------------------------------------------*/

int f_get_outgoing(void)
{
  return stream->outgoing;
}

/*---------------------------------------------------------------------------*/
  
int f_get_frack(void)
{ if(l2found && stream->number)
    return l2_frack(stream->number);
  else
    return 40;
}

/*---------------------------------------------------------------------------*/

unsigned f_get_logintime(void)
{ return stream->logintime;
}

/*---------------------------------------------------------------------------*/

char *f_get_concall(void)
{
  return q->path;
}

/* management functions, SET-operation */

/*---------------------------------------------------------------------------*/

void f_set_partner(char *call)
{ strcpy(stream->partner,call);
}

/*---------------------------------------------------------------------------*/

void f_set_conok(int on)
{ stream->mode.open=on;
}

/*---------------------------------------------------------------------------*/

void f_set_messages(int on)
{ stream->mode.messages=on;
}

/*---------------------------------------------------------------------------*/
  
  void f_set_channel(int channel)
{ if(selected_stream==0)
    stream->channel=channel;
}

/*---------------------------------------------------------------------------*/

void f_set_qsonum(int qsonum,int lstate)
{
  if(l2found)
  { stream->number=qsonum;

    q->last_lstate=lstate;
    const FRAME far *fr=l2_get_f(qsonum);
    strcall(q->mycall,fr->source);
    stream->channel=fr->kanal;
  }
}

/*---------------------------------------------------------------------------*/

int f_get_qsonum(void)
{ return stream->number;
}

/*---------------------------------------------------------------------------*/
  
  void f_set_stream(int stream_number)
{ if(stream_number<streams)
  { stream=&stream_arr[stream_number];
    selected_stream=stream_number;
    q=&qso[stream_number];
  }
  else
    printf("illegal stream %d\n",stream_number);
}

/*---------------------------------------------------------------------------*/

void f_set_monitor(char *s)
{
  if(l2found)
    l2_clr_monitor();
  else
    return;

  strupr(s);
  memset(&tr,0,sizeof(TRACE));
  if(strcmp(s,"OFF")==0)
    return;
  tr.trxfilter=3;
  tr.ch_mask=0;

  while(s[0])
  { s+=blkill(s);
    if(s[0]==0) break;
    switch(s[0])
    { case '>': tr.trxfilter=2; break;
      case '<': tr.trxfilter=1; break;
      case '#': tr.typfilter|=TRACETYP_NO_S; break;
      case '$': tr.typfilter|=TRACETYP_NO_TEXT; break;
      default:
        if(s[0]>='0' && s[0]<='9' && s[1]<='9')
        { tr.ch_mask |= 1<<atoi(s);
          while(s[0]>' ') s++;
        }
        else if(s[0]=='-')
        { tr.ch_mask = 0xffff;
          while(s[0]>' ') s++;
        }
        else if(s[0]=='O' && s[1]=='N' && s[2]<=' ')
        { tr.ch_mask=0xffff;
          s+=2;
        }
        else if(isalnum(s[0]))
        { int i=0;
          while(s[0]>='0' && i<6)
          { tr.call[i]=s[0];
            s++;i++;
          }
          while(i<6) tr.call[i++]=' ';
          if(s[0]=='-')
          { s++;
            i=atoi(s);
            tr.call[6]=i+0x30;
            while(s[0]>' ') s++;
          }
        }
    }
    s++;
  }
}

/*---------------------------------------------------------------------------*/

char *f_get_monitor(void)
{ static char erg[30];

  erg[0]=0;
  if(tr.trxfilter==0 || tr.ch_mask==0x0000)
    return "OFF";

  if(!l2found || tr.ch_mask==0xffff)
    strcpy(erg,"ON");
  else
  { int i;
    for(i=0;i<16;i++)
      if((tr.ch_mask>>i)&1)
        sprintf(erg+strlen(erg),"%d ",i);
  }
  if(tr.call[0])
  { strcall(erg+strlen(erg),tr.call);
    strcat(erg," ");
  }

  if(tr.trxfilter != 3)
  { if(tr.trxfilter==2)
      strcat(erg,"> ");
    if(tr.trxfilter==1)
      strcat(erg,"< ");
  }
  if(tr.typfilter&TRACETYP_NO_S)
    strcat(erg,"# ");
  if(tr.typfilter&TRACETYP_NO_TEXT)
    strcat(erg,"$ ");
  return erg;
}

/*---------------------------------------------------------------------------*/

void f_set_l1_txdelay(int channel,int txd)
{ if(l2found && ch_active(channel))
    set_txdelay(channel,txd);
}

/*---------------------------------------------------------------------------*/

int f_get_l1_txdelay(int channel)
{ if(l2found && ch_active(channel))
    return get_txdelay(channel);
  else
    return 0;
}

/*---------------------------------------------------------------------------*/

#define MODE_x   0x8000
#define MODE_a   0x0100
#define MODE_y   0x0200
#define MODE_m   0x0400
#define MODE_s   0x0800
#define MODE_d   0x0080
#define MODE_r   0x0040
#define MODE_t   0x0020
#define MODE_z   0x0010
#define MODE_u   0x0008
#define MODE_b   0x0004
#define MODE_c   0x0002
#define MODE_off 0x0001   /* Special: Wenn 1, Kanal abgeschaltet */

void f_set_l1_mode(int channel,char *m)
{ long baud=atol(m);
  unsigned mode=0;
  if(l2found && ch_active(channel))
  {
    l2_set_monitor(&tr);
    strlwr(m);
    while(m[0])
    { switch(m[0])
      { case 'u': mode|=MODE_u; break;
        case 't': mode|=MODE_t; break;
        case 'r': mode|=MODE_r; break;
        case 'z': mode|=MODE_z; break;
        case 'd': mode|=MODE_d; break;
        case 'c': mode|=MODE_c; break;
        case 'a': mode|=MODE_a; break;
        case 'm': mode|=MODE_m; break;
        case 'y': mode|=MODE_y; break;
        case 's': mode|=MODE_s; break;
        case 'x': mode|=MODE_x; break;
        case 'b': mode|=MODE_b; break;
        case '-': mode|=MODE_off; break;
      }
      m++;
    }
    set_chmode(channel,(u16)mode,(u16)(baud/100));
  }
}

/*---------------------------------------------------------------------------*/

char *f_get_l1_mode(int channel)
{ static char erg[30];
  unsigned mode;

  if(l2found && ch_active(channel))
  {
    int baud=get_chbaud(channel);
    if(baud)
      sprintf(erg,"%ld",100L*baud);
    else
      erg[0]=0;
    mode=get_chmode(channel);
    if(mode==0 && strlen(erg)<2)
      return "";
    if(mode & MODE_s)
      strcat(erg,"s");
    if(mode & MODE_m)
      strcat(erg,"m");
    if(mode & MODE_y)
      strcat(erg,"y");
    if(mode & MODE_u)
      strcat(erg,"u");
    if(mode & MODE_d)
      strcat(erg,"d");
    if(mode & MODE_t)
      strcat(erg,"t");
    if(mode & MODE_r)
      strcat(erg,"r");
    if(mode & MODE_z)
      strcat(erg,"z");
    if(mode & MODE_c)
      strcat(erg,"c");
    if(mode & MODE_a)
      strcat(erg,"a");
    if(mode & MODE_x)
      strcat(erg,"x");
    if(mode & MODE_b)
      strcat(erg,"b");
    if(mode & MODE_off)
      strcat(erg,"-");
    return erg;
  }
  else
    return "";
}

/*---------------------------------------------------------------------------*/
  
  void f_set_l1_xmitok(int channel,int xmitok)
{ if(l2found && ch_active(channel))
  { unsigned mode=get_chmode(channel);
    unsigned baud=get_chbaud(channel);
    if(xmitok==0)
      mode|=MODE_x;
    else
      mode&=(~MODE_x);
    set_chmode(channel,mode,baud);
  }
}

/*---------------------------------------------------------------------------*/
  
  int f_get_l1_xmitok(int channel)
{ if(l2found && ch_active(channel))
    return !(get_chmode(channel)&MODE_x);
  else
    return (-1);
}

/*---------------------------------------------------------------------------*/

char *f_get_version(void)
{
  static char version[20]="";
  if(l2found)
    sprintf(version,"Flx%c%s",(flx_ver==2)?'D':' ',l2_version());
  return version;
}
