/***************************************************************

  BayCom(R)           Packet-Radio for IBM PC

  BayCom-Terminal


  ----------------------------------------------
  Definitions / Declarations for BayCom-Terminal
  ----------------------------------------------


  Copyright (C) 1999 Flori Radlherr, DL8MBT, flori@baycom.org
      
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ***************************************************************/


#ifndef _BCT_H
#define _BCT_H

#define VNUMMER      "1.61"
#define YEAR         "1998"

// some defines for platform dependend functions
// (BCT is DOS only and will never be portable ;-)
#define __HWSCREEN__
#define __DOS16__

// let's include some often used headers
#include <ctype.h>
#include <fcntl.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <setjmp.h>

// non portable includes
#include <dos.h>
#include <conio.h>
#include <bios.h>
#include <io.h>
#include <dir.h>
#include <alloc.h>
#include <share.h>

// Just for code compatibility. Others than english is not more supported
#define ENGLISCH     1

typedef unsigned char byte;
typedef int handle;

// to make the DOS-Compiler happy..
#ifndef __LINUX__
# define strncasecmp strnicmp
#endif

// Borland C++ does not know the ANSI type bool, let's define it
typedef int bool;
typedef enum _bool { false,true } _bool;

//
// Some defines to make (probably) the code more readable..
//
#define FNLEN        50         // max Laenge eines Filenamen
#define REMLEN       80         // Laenge des Remote-Buffers
#define FALSE    0
#define NO       0
#define ERROR    0
#define NOTFOUND (-1)
#define TRUE     1
#define OK       1
#define YES      1
#define SAME     0
#define LOWER    1
#define HIGHER   2
#define NIL      (-1)
#define JA   1
#define NEIN 0
#define JEIN -1

#include "l2_appl.h"
#include "mouse.h"

#define VIDNAME       "video.bct"
#define LOGNAME       "log.bct"

#define INITNAME      "init.bct"
#define INITTMPNAME   "init.$$$"
#define INITBAKNAME   "init.bak"

#define PARNAME       "para.l2"
#define ININAME       "init.l2"
#define PWDNAME       "passwd.bct"
#define TERMHELPNAME  "help.bct"

typedef unsigned video;

#define MAXTERMPORTS  9
#define MAXSTLEN     4000          // maximale Laenge der Standardtexte
#define MAXRECON      10

//
//  Fuer jeden Bildschirm getrennt
//
typedef struct taskvar_t
{ int      port;
  char     stop;
  char     blinkon;
  char     pwscharf;
  char     connscharf;
  char     pwok;
  char     waitpw;
  char     german;             // wenn IBM-Zeichen gekommen ist
  char     lastchar;
  char     ismailbox;
  int      privoffset;
  long     logintime;
  int      waitbin;
  char     rembuf[REMLEN];
  int      remindex;
  char     recon[MAXRECON][10];
  unsigned connlines;
  char     pwstr[6];
  FILE    *file;
  char     filename[FNLEN];
  char     defaultfilename[FNLEN];
  char     filejob;
  long     filepos;
  long     filelen;
  unsigned crcword;
  int      filedos;
  char     waitcall[10];   // Calls, auf die gewartet wird
  int      waitstptr;      // Position, an der unterbr. wurde
  char     waitstaste;     // Text, der fortgesetzt wird

  char    *sendbuffer;
  int      send_in;
  int      send_out;
  video   *txbufptr;
  video   *rxbufptr;
  unsigned txbufbegin;
  unsigned rxbufbegin;
  unsigned txbufend;
  unsigned rxbufend;
  unsigned txbufvideo;
  unsigned rxbufvideo;
  char     cbufcolumn;
  char     cbufline;
  char     rbufcolumn;
  char     rbufline;
} taskvar_t;

typedef enum
{ txcolor,
  stat1normal,
  stat1stop,
  rxcolor,
  stat2active,
  stat2idle,
  stat2on,
  monheader,
  moninfo,
  helpcolor,
  helphilight,
  helpselect,
  ctlcolor,
  maxcolor,       // mu stets hinter dem hchsten Farbwert stehen
  blackcolor
} farbe_t;

typedef enum filejob_t
{ nofile,
  stextfile,
  sbinfile,
  rtextfile,
  rbinfile,
  rtext7plus,
  etextfile,
  vtextfile
} filejob_t;

extern char st[];

//
//  Programmglobale Setup-Parameter
//
//
typedef struct term_para_t
{ video    attr[2*maxcolor];
  char     rcmdstring[80];

  char l1_mode[16][20];
  unsigned l1_txdelay[16];
  char monitor[40];

  char ctext;
  char qtext;

  unsigned mouseon;
  unsigned remoteon;
  unsigned germanon;
  unsigned command;
  unsigned logfileon;
  unsigned exitlog;
  unsigned insmode;
  unsigned dosclear;
  unsigned echo;
  unsigned cbell;
  unsigned knax;
  unsigned autobin;
  unsigned p7psave;
  unsigned colordisp;
  unsigned vgalines;

  unsigned divline;
  unsigned txwinlen;
  unsigned termlines;
  unsigned termcolumn;
  unsigned wordwrap;
  unsigned crtsave;

  char     boxcalls[80];
  char     mycall[10][12];
  char     linkkanal[10];
  char     linkcall[10][10];
  char     defdigi[10];
  unsigned inidate;        // Datum von SCC.INI ganz am Ende, damit jede
  unsigned initime;        // nderung im Format von SCC.PAR erkannt wird
  unsigned kennung;
} term_para_t;


extern taskvar_t bfeld[MAXTERMPORTS];
extern taskvar_t *b;

/*
 *   Video-Definitionen
 *
 */
#define a(x,y)      (((x)<<8) | ((y)<<12))
#define putln(x)    putvs(x),putv(13)
#define crlf()      putv(13)
#define cadr        (vram+(maxcol*line[wnd])+column[wnd])
#define ladr        (vram+(maxcol*line[wnd]))
#define WINDOWS 6           /* TX, Status, RX, Status2, Monitor */
#define BILDAUS MAXTERMPORTS-1
#define taste() (peek(0x40,0x1a)!=peek(0x40,0x1c))
/* gleicher Effekt aber erheblich schneller als kbhit()  */

typedef enum WND
{ txwin,
  statln,
  rxwin,
  stat2,
  monwin,
  xwin
};

extern int uninit;
extern int doppunkt;
extern int nol1par;
extern int mode_changed;

/* Globale Variablen fr Video-Zugriff */

extern video far *vram;
extern video att;
extern video catt;
extern char colset;

extern char maxline;
extern char maxcol;

extern char top[];
extern char bottom[];
extern char line[];
extern char column[];
extern enum WND wnd;

extern char remotefl;
extern char prgende;
extern char curwin;
extern int bildport;
extern int maxports;
extern int miniram;
extern long unsigned freekb;

extern struct l2_para_t far *wl;
extern struct term_para_t far *wt;
extern char *lstext[];

extern int setuprun;

extern char mycall[10][12];
extern int  mynum;


void putvsetup1(int);

void set_context(int port);
void set_tnc_context(int port);

int  putprompt(int ins);
void dosabspeichern(int platz);
void dosvideo(void);
void sccvideo(void);
void settextinfo(struct text_info *mode);
void set_color(farbe_t farbe,int statline);
void cls(void);
void setzcurs(int tx);
void scroll(int anschlag);
int scrolldn(int anschlag);
void putvo(int);
void putv(int buchst);
void initvideo(void);
void statst(int sofort);
void winreorg(void);
void screenrestore(void);
void screensave(void);
void curoben(void);
void portset(int port);
void inschar(int immer);
void delchar(void);
void ctrlzeichen(char scancode,int vontaste,bool shift=false);
void bildplatte(void);
int  plattebild(void);
void screenoff(void);
void screenon(void);

void setup(char *,int);

// te_help.cpp
void puthelp(char *befehl);
void lasthelp(void);

// te_crit.c
extern int critical_error;
int crit_handler(int errval,int ax,int bp,int si);

char *nextarg(char *prevarg);
int loadpar(void);
void savepar(void);
int check_node(void);

#define MAXWND 10

#define COL    0x17
#define HCOL   0x02
#define ECOL   0x4f

#define MDA    0x70
#define HMDA   0x07
#define EMDA   0x0f

#define EIN    1
#define AUS    0

extern unsigned vseg;

typedef int wind;
typedef unsigned video;

typedef struct
{ char x;
  char y;
  char xlen;
  char ylen;
  int curx;
  int cury;
  video far *save;
} wndstruc;

// some window-functions drawing nice frames around the windows
void setlinlen(int len);
void wc(int x,int y,int attr,char c);
void ws(int x,int y,int attr,char *s);
void wf(int x,int y,int attr,char *format,...);
void wclear(wind w,int col);
void wstr(wind w,int line,int col,char *s);
void whelp(wind w,int line,int col,int hcol,char *s);
void menuselect(wind w,int hcol,int scol,char *befehl);
void wframe(wind w,int col,char *headerln);
wind wopen(int x,int y,int xlen,int ylen,video *save);
void wclose(wind w);
int xpos(wind w);
int ypos(wind w);
void cset(wind w,int curx,int cury);


extern char globalpath[];
char *getname(char *call);
void filepath(char *name,char *filename);
FILE *sysopen(char *name,char *mode);
char *syspath(char *name);
void fixpath(void);
void subst(char *s,char i,char j);

void putv(int);
void putvsetup(int);
void putvs(char *string);
void putf(char *format, ...);

int  blkill(char *bf);
char *putzeit(long unsigned);
char *zeitstring(long unsigned);
int  readcmd(char **,char **,int);
int  nextdez(char **buffer);

char *dirline(char *mask,int mode);
char *modifymask(char *mask);


// Standard text prototypes
#define NIXDRIN (-1)

void stinput(char *befbuf);   // ST-Eingabe
void stlist(char *id);        // Ausgabe der ST-Liste. id: nur 1 Text
void stdelete(char *id);      // einen Text lschen
char *stfind(char *id);       // nach einem Text suchen
int next_st_char();           // holt ggf den nchsten ST-Buchstaben
int st_taste(int scan);       // wertet SCAN-Code einer Taste aus
int stbereit(void);
int waitpoll();
void stsend(char buchst);

#endif // _BCT_H

